/*
 * Decompiled with CFR 0.152.
 */
package io.ionic.libs.ionfilesystemlib.helper.common;

import android.annotation.SuppressLint;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import io.ionic.libs.ionfilesystemlib.helper.common.IONFILEBuildConfig;
import io.ionic.libs.ionfilesystemlib.model.IONFILECreateOptions;
import io.ionic.libs.ionfilesystemlib.model.IONFILEDeleteOptions;
import io.ionic.libs.ionfilesystemlib.model.IONFILEExceptions;
import io.ionic.libs.ionfilesystemlib.model.IONFILEFileType;
import io.ionic.libs.ionfilesystemlib.model.IONFILEMetadataResult;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u001a+\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\u0010\u0012\u001a#\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\u0010\u0015\u001a\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0001\u001a\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\tH\u0002\u001a\\\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u000726\u0010\u001e\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\r0\u001fH\u0080\b\u00f8\u0001\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006$"}, d2={"FILE_3GA_EXTENSION", "", "FILE_3GA_MIME_TYPE", "FILE_JAVASCRIPT_EXTENSION", "FILE_JAVASCRIPT_MIME_TYPE", "FILE_MIME_TYPE_FALLBACK", "checkParentDirectory", "", "file", "Ljava/io/File;", "create", "createDirOrFile", "Lkotlin/Result;", "", "fullPath", "options", "Lio/ionic/libs/ionfilesystemlib/model/IONFILECreateOptions;", "isDirectory", "(Ljava/lang/String;Lio/ionic/libs/ionfilesystemlib/model/IONFILECreateOptions;Z)Ljava/lang/Object;", "deleteDirOrFile", "Lio/ionic/libs/ionfilesystemlib/model/IONFILEDeleteOptions;", "(Ljava/lang/String;Lio/ionic/libs/ionfilesystemlib/model/IONFILEDeleteOptions;)Ljava/lang/Object;", "getMetadata", "Lio/ionic/libs/ionfilesystemlib/model/IONFILEMetadataResult;", "fileObject", "getMimeType", "prepareForCopyOrRename", "sourcePath", "destinationPath", "forDirectories", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "sourceFileObj", "destinationFileObj", "IONFilesystemLib_release"})
@SourceDebugExtension(value={"SMAP\nIONFILECommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IONFILECommon.kt\nio/ionic/libs/ionfilesystemlib/helper/common/IONFILECommonKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1#2:167\n*E\n"})
public final class IONFILECommonKt {
    @NotNull
    public static final String FILE_MIME_TYPE_FALLBACK = "application/octet-binary";
    @NotNull
    private static final String FILE_3GA_EXTENSION = "3ga";
    @NotNull
    private static final String FILE_3GA_MIME_TYPE = "audio/3gpp";
    @NotNull
    private static final String FILE_JAVASCRIPT_EXTENSION = "js";
    @NotNull
    private static final String FILE_JAVASCRIPT_MIME_TYPE = "text/javascript";

    @NotNull
    public static final Object createDirOrFile(@NotNull String fullPath, @NotNull IONFILECreateOptions options, boolean isDirectory) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        try {
            boolean bl = false;
            File file = new File(fullPath);
            if (file.exists()) {
                throw new IONFILEExceptions.CreateFailed.AlreadyExists(fullPath);
            }
            if (!IONFILECommonKt.checkParentDirectory(file, options.getRecursive())) {
                throw new IONFILEExceptions.CreateFailed.NoParentDirectory();
            }
            if (isDirectory && !file.mkdir()) {
                throw new IONFILEExceptions.UnknownError(null, 1, null);
            }
            if (!isDirectory && !file.createNewFile()) {
                throw new IONFILEExceptions.UnknownError(null, 1, null);
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    @NotNull
    public static final Object deleteDirOrFile(@NotNull String fullPath, @NotNull IONFILEDeleteOptions options) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        try {
            boolean deleteSucceeded;
            boolean bl = false;
            File file = new File(fullPath);
            if (!file.exists()) {
                throw new IONFILEExceptions.DoesNotExist(fullPath, null, 2, null);
            }
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (!(fileArray == null || fileArray.length == 0) && !options.getRecursive()) {
                    throw new IONFILEExceptions.DeleteFailed.CannotDeleteChildren();
                }
                v0 = FilesKt.deleteRecursively((File)file);
            } else {
                v0 = deleteSucceeded = file.delete();
            }
            if (!deleteSucceeded) {
                throw new IONFILEExceptions.UnknownError(null, 1, null);
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    @SuppressLint(value={"NewApi"})
    @NotNull
    public static final IONFILEMetadataResult getMetadata(@NotNull File fileObject) {
        Long l;
        IONFILEFileType iONFILEFileType;
        Intrinsics.checkNotNullParameter((Object)fileObject, (String)"fileObject");
        String string = fileObject.getAbsolutePath();
        String string2 = fileObject.getName();
        long l2 = fileObject.length();
        Uri uri = Uri.fromFile((File)fileObject);
        IONFILEFileType iONFILEFileType2 = iONFILEFileType = fileObject.isDirectory() ? (IONFILEFileType)IONFILEFileType.Directory.INSTANCE : (IONFILEFileType)new IONFILEFileType.File(IONFILECommonKt.getMimeType(fileObject));
        if (IONFILEBuildConfig.INSTANCE.getAndroidSdkVersionCode() > 26) {
            BasicFileAttributes attr = Files.readAttributes(fileObject.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            boolean bl = false;
            l = Math.min(attr.creationTime().toMillis(), attr.lastAccessTime().toMillis());
        } else {
            l = null;
        }
        Long l3 = l;
        long l4 = fileObject.lastModified();
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNull((Object)string2);
        Intrinsics.checkNotNull((Object)uri);
        return new IONFILEMetadataResult(string, string2, uri, l2, iONFILEFileType, l3, l4);
    }

    public static final void prepareForCopyOrRename(@NotNull String sourcePath, @NotNull String destinationPath, boolean forDirectories, @NotNull Function2<? super File, ? super File, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullParameter((Object)destinationPath, (String)"destinationPath");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$prepareForCopyOrRename = false;
        File sourceFileObj = new File(sourcePath);
        File destinationFileObj = new File(destinationPath);
        if (Intrinsics.areEqual((Object)sourceFileObj, (Object)destinationFileObj)) {
            return;
        }
        if (!sourceFileObj.exists()) {
            throw new IONFILEExceptions.DoesNotExist(sourcePath, null, 2, null);
        }
        if (!forDirectories && (sourceFileObj.isDirectory() || destinationFileObj.isDirectory())) {
            throw new IONFILEExceptions.CopyRenameFailed.MixingFilesAndDirectories();
        }
        if (forDirectories && (sourceFileObj.isFile() || destinationFileObj.isFile())) {
            throw new IONFILEExceptions.CopyRenameFailed.MixingFilesAndDirectories();
        }
        File file = destinationFileObj.getParentFile();
        boolean bl = file != null ? !file.exists() : false;
        if (bl) {
            throw new IONFILEExceptions.CopyRenameFailed.NoParentDirectory();
        }
        if (forDirectories && destinationFileObj.isDirectory()) {
            throw new IONFILEExceptions.CopyRenameFailed.DestinationDirectoryExists(destinationPath);
        }
        block.invoke((Object)sourceFileObj, (Object)destinationFileObj);
    }

    private static final String getMimeType(File fileObject) {
        CharSequence charSequence;
        CharSequence charSequence2 = FilesKt.getExtension((File)fileObject);
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = fileObject.getPath();
        } else {
            charSequence = charSequence2;
        }
        String extension = (String)charSequence;
        String resolvedExtension = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        if (resolvedExtension == null) {
            String string = extension;
            resolvedExtension = Intrinsics.areEqual((Object)string, (Object)FILE_3GA_EXTENSION) ? FILE_3GA_MIME_TYPE : (Intrinsics.areEqual((Object)string, (Object)FILE_JAVASCRIPT_EXTENSION) ? FILE_JAVASCRIPT_MIME_TYPE : FILE_MIME_TYPE_FALLBACK);
        }
        return resolvedExtension;
    }

    private static final boolean checkParentDirectory(File file, boolean create) {
        boolean bl;
        File file2 = file.getParentFile();
        if (file2 != null) {
            File it = file2;
            boolean bl2 = false;
            bl = it.exists() || create && it.mkdirs();
        } else {
            bl = false;
        }
        return bl;
    }
}

