/*
 * Decompiled with CFR 0.152.
 */
package io.ionic.libs.ionfiletransferlib.helpers;

import io.ionic.libs.ionfiletransferlib.model.IONFLTRException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lio/ionic/libs/ionfiletransferlib/helpers/IONFLTRInputsValidator;", "", "()V", "isPathValid", "", "path", "", "isURLValid", "url", "validateTransferInputs", "", "filePath", "IONFileTransferLib_release"})
public final class IONFLTRInputsValidator {
    public final void validateTransferInputs(@NotNull String url, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (StringsKt.isBlank((CharSequence)url)) {
            throw new IONFLTRException.EmptyURL(url);
        }
        if (!this.isURLValid(url)) {
            throw new IONFLTRException.InvalidURL(url);
        }
        if (!this.isPathValid(filePath)) {
            throw new IONFLTRException.InvalidPath(filePath);
        }
    }

    private final boolean isPathValid(String path) {
        boolean bl;
        CharSequence charSequence = path;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        try {
            String uri = new URI(path).getPath();
            bl = new File(uri).isAbsolute();
        }
        catch (URISyntaxException e) {
            bl = false;
        }
        return bl;
    }

    private final boolean isURLValid(String url) {
        Pattern pattern = Pattern.compile("http[s]?://(([^/:.[:space:]]+(.[^/:.[:space:]]+)*)|([0-9](.[0-9]{3})))(:[0-9]+)?((/[^?#[:space:]]+)([^#[:space:]]+)?(#.+)?)?");
        return pattern.matcher(url).find();
    }
}

