/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.springboot.starter;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.Cloner;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceOverrider;
import io.javaoperatorsdk.operator.api.config.ControllerConfigurationOverrider;
import io.javaoperatorsdk.operator.api.config.DefaultResourceClassResolver;
import io.javaoperatorsdk.operator.api.config.ResourceClassResolver;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.processing.retry.GenericRetry;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import io.javaoperatorsdk.operator.springboot.starter.CRDApplier;
import io.javaoperatorsdk.operator.springboot.starter.KubernetesClientProperties;
import io.javaoperatorsdk.operator.springboot.starter.KubernetesConfigCustomizer;
import io.javaoperatorsdk.operator.springboot.starter.OperatorConfigurationProperties;
import io.javaoperatorsdk.operator.springboot.starter.OperatorStarter;
import io.javaoperatorsdk.operator.springboot.starter.ReconcilerProperties;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@EnableConfigurationProperties(value={OperatorConfigurationProperties.class})
public class OperatorAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OperatorAutoConfiguration.class);
    @Autowired
    private OperatorConfigurationProperties configuration;

    @Bean
    @ConditionalOnMissingBean
    public KubernetesClient kubernetesClient(Optional<HttpClient.Factory> httpClientFactory, Config config) {
        return this.configuration.getClient().isOpenshift() ? (KubernetesClient)httpClientFactory.map(it -> (OpenShiftClient)new KubernetesClientBuilder().withHttpClientFactory(it).withConfig(config).build().adapt(OpenShiftClient.class)).orElseGet(() -> (OpenShiftClient)new KubernetesClientBuilder().withConfig(config).build().adapt(OpenShiftClient.class)) : httpClientFactory.map(it -> new KubernetesClientBuilder().withHttpClientFactory(it).withConfig(config).build()).orElseGet(() -> new KubernetesClientBuilder().withConfig(config).build());
    }

    @Bean
    @ConditionalOnMissingBean(value={ResourceClassResolver.class})
    public ResourceClassResolver resourceClassResolver() {
        return new DefaultResourceClassResolver();
    }

    @Bean
    @ConditionalOnProperty(value={"javaoperatorsdk.crd.apply-on-startup"}, havingValue="true")
    public CRDApplier crdApplier(KubernetesClient client, List<CRDApplier.CRDTransformer> transformers) {
        OperatorConfigurationProperties.CrdProperties crd = this.configuration.getCrd();
        return new CRDApplier.DefaultCRDApplier(client, transformers, crd.getPath(), crd.getSuffix());
    }

    @Bean
    @ConditionalOnMissingBean(value={CRDApplier.class})
    public CRDApplier disabledCrdApplier() {
        return CRDApplier.NOOP;
    }

    @Bean
    public OperatorStarter operatorStarter(Operator operator, CRDApplier applier) {
        return new OperatorStarter(operator, applier);
    }

    @Bean(destroyMethod="stop")
    @ConditionalOnMissingBean(value={Operator.class})
    public Operator operator(BiConsumer<Operator, Reconciler<?>> reconcilerRegisterer, @Qualifier(value="compositeConfigurationServiceOverrider") Consumer<ConfigurationServiceOverrider> compositeConfigurationServiceOverrider, KubernetesClient kubernetesClient, List<Reconciler<?>> reconcilers) {
        Operator operator = new Operator(kubernetesClient, compositeConfigurationServiceOverrider);
        reconcilers.forEach(reconciler -> reconcilerRegisterer.accept(operator, (Reconciler<?>)reconciler));
        return operator;
    }

    @Bean
    public BiConsumer<Operator, Reconciler<?>> reconcilerRegisterer() {
        return (operator, reconciler) -> {
            String name = ReconcilerUtils.getNameFor((Reconciler)reconciler);
            ReconcilerProperties props = this.configuration.getReconcilers().get(name);
            operator.register(reconciler, overrider -> this.overrideFromProps((ControllerConfigurationOverrider<?>)overrider, props));
        };
    }

    @Bean
    public Consumer<ConfigurationServiceOverrider> compositeConfigurationServiceOverrider(List<Consumer<ConfigurationServiceOverrider>> configServiceOverriders) {
        return (Consumer)configServiceOverriders.stream().reduce(Consumer::andThen).orElseThrow(() -> new IllegalStateException("Default Config Service Overrider Not Created"));
    }

    @Bean
    @Order(value=0)
    public Consumer<ConfigurationServiceOverrider> defaultConfigServiceOverrider(@Autowired(required=false) Cloner cloner, ResourceClassResolver resourceClassResolver, Metrics metrics) {
        return overrider -> {
            this.doIfPresent(cloner, arg_0 -> ((ConfigurationServiceOverrider)overrider).withResourceCloner(arg_0));
            this.doIfPresent(this.configuration.getMinConcurrentWorkflowExecutorThreads(), arg_0 -> ((ConfigurationServiceOverrider)overrider).withMinConcurrentWorkflowExecutorThreads(arg_0));
            this.doIfPresent(this.configuration.getMinConcurrentReconciliationThreads(), arg_0 -> ((ConfigurationServiceOverrider)overrider).withMinConcurrentReconciliationThreads(arg_0));
            this.doIfPresent(this.configuration.getStopOnInformerErrorDuringStartup(), arg_0 -> ((ConfigurationServiceOverrider)overrider).withStopOnInformerErrorDuringStartup(arg_0));
            this.doIfPresent(this.configuration.getConcurrentWorkflowExecutorThreads(), arg_0 -> ((ConfigurationServiceOverrider)overrider).withConcurrentWorkflowExecutorThreads(arg_0));
            this.doIfPresent(this.configuration.getCloseClientOnStop(), arg_0 -> ((ConfigurationServiceOverrider)overrider).withCloseClientOnStop(arg_0));
            this.doIfPresent(this.configuration.getCacheSyncTimeout(), arg_0 -> ((ConfigurationServiceOverrider)overrider).withCacheSyncTimeout(arg_0));
            overrider.withConcurrentReconciliationThreads(this.configuration.getConcurrentReconciliationThreads()).withMetrics(metrics).withResourceClassResolver(resourceClassResolver).checkingCRDAndValidateLocalModel(this.configuration.getCheckCrdAndValidateLocalModel());
        };
    }

    private void overrideFromProps(ControllerConfigurationOverrider<?> overrider, ReconcilerProperties props) {
        if (props != null) {
            this.doIfPresent(props.getFinalizerName(), arg_0 -> overrider.withFinalizer(arg_0));
            this.doIfPresent(props.getName(), arg_0 -> overrider.withName(arg_0));
            this.doIfPresent(props.getNamespaces(), arg_0 -> overrider.settingNamespaces(arg_0));
            this.doIfPresent(props.getRetry(), r -> {
                GenericRetry retry = new GenericRetry();
                this.doIfPresent(r.getInitialInterval(), arg_0 -> ((GenericRetry)retry).setInitialInterval(arg_0));
                this.doIfPresent(r.getMaxAttempts(), arg_0 -> ((GenericRetry)retry).setMaxAttempts(arg_0));
                this.doIfPresent(r.getMaxInterval(), arg_0 -> ((GenericRetry)retry).setMaxInterval(arg_0));
                this.doIfPresent(r.getIntervalMultiplier(), arg_0 -> ((GenericRetry)retry).setIntervalMultiplier(arg_0));
                overrider.withRetry((Retry)retry);
            });
            this.doIfPresent(props.isGenerationAware(), arg_0 -> overrider.withGenerationAware(arg_0));
            this.doIfPresent(props.isClusterScoped(), clusterScoped -> {
                if (clusterScoped.booleanValue()) {
                    overrider.watchingAllNamespaces();
                }
            });
            this.doIfPresent(props.getLabelSelector(), arg_0 -> overrider.withLabelSelector(arg_0));
            this.doIfPresent(props.getReconciliationMaxInterval(), arg_0 -> overrider.withReconciliationMaxInterval(arg_0));
        }
    }

    @Bean
    @ConditionalOnMissingBean(name={"reconciliationExecutorService"})
    public ExecutorService reconciliationExecutorService() {
        return Executors.newFixedThreadPool(this.configuration.getConcurrentReconciliationThreads());
    }

    @Bean
    @ConditionalOnMissingBean(value={Metrics.class})
    public Metrics metrics() {
        return Metrics.NOOP;
    }

    @Bean
    public Config getClientConfiguration(@Autowired(required=false) KubernetesConfigCustomizer configCustomizer) {
        return this.configuration.getClient().getContext().map(Config::autoConfigure).map(it -> {
            if (configCustomizer != null) {
                ConfigBuilder builder = new ConfigBuilder(it);
                configCustomizer.customize(builder);
                return builder.build();
            }
            return it;
        }).orElseGet(() -> {
            KubernetesClientProperties clientCfg = this.configuration.getClient();
            ConfigBuilder config = new ConfigBuilder();
            config.withTrustCerts(clientCfg.isTrustSelfSignedCertificates());
            clientCfg.getMasterUrl().ifPresent(arg_0 -> ((ConfigBuilder)config).withMasterUrl(arg_0));
            clientCfg.getUsername().ifPresent(arg_0 -> ((ConfigBuilder)config).withUsername(arg_0));
            clientCfg.getPassword().ifPresent(arg_0 -> ((ConfigBuilder)config).withPassword(arg_0));
            if (configCustomizer != null) {
                configCustomizer.customize(config);
            }
            return config.build();
        });
    }

    private <T> void doIfPresent(T prop, Consumer<T> action) {
        Optional.ofNullable(prop).ifPresent(action);
    }
}

