/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.springboot.starter;

import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.RuntimeInfo;
import java.util.Map;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class OperatorHealthIndicator
extends AbstractHealthIndicator {
    private final Operator operator;

    public OperatorHealthIndicator(Operator operator) {
        super("OperatorSDK health check failed");
        Assert.notNull((Object)operator, (String)"OperatorSDK Operator not initialized");
        this.operator = operator;
    }

    protected void doHealthCheck(Health.Builder builder) {
        RuntimeInfo runtimeInfo = this.operator.getRuntimeInfo();
        if (runtimeInfo.isStarted()) {
            boolean[] healthy = new boolean[]{true};
            runtimeInfo.getRegisteredControllers().forEach(rc -> {
                String name = rc.getConfiguration().getName();
                Map unhealthy = rc.getControllerHealthInfo().unhealthyEventSources();
                if (unhealthy.isEmpty()) {
                    builder.withDetail(name, (Object)"OK");
                } else {
                    healthy[0] = false;
                    builder.withDetail(name, (Object)("unhealthy: " + String.join((CharSequence)", ", unhealthy.keySet())));
                }
            });
            if (healthy[0]) {
                builder.up();
            } else {
                builder.down();
            }
        } else {
            builder.unknown();
        }
    }
}

