/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.config.runtime;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.config.runtime.ClassMappingProvider;
import java.util.Map;

public class RuntimeControllerMetadata {
    public static final String RECONCILERS_RESOURCE_PATH = "javaoperatorsdk/reconcilers";
    private static final Map<Class<? extends Reconciler>, Class<? extends HasMetadata>> controllerToCustomResourceMappings = ClassMappingProvider.provide("javaoperatorsdk/reconcilers", Reconciler.class, HasMetadata.class);

    static <R extends HasMetadata> Class<R> getResourceClass(Reconciler<R> reconciler) {
        Class<? extends HasMetadata> resourceClass = controllerToCustomResourceMappings.get(reconciler.getClass());
        if (resourceClass == null) {
            throw new IllegalArgumentException(String.format("No custom resource has been found for controller %s", reconciler.getClass().getCanonicalName()));
        }
        return resourceClass;
    }
}

