/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.config.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;

class TypeParameterResolver {
    private final DeclaredType interestedClass;
    private final int interestedTypeArgumentIndex;

    public TypeParameterResolver(DeclaredType interestedClass, int interestedTypeArgumentIndex) {
        this.interestedClass = interestedClass;
        this.interestedTypeArgumentIndex = interestedTypeArgumentIndex;
    }

    public TypeMirror resolve(Types typeUtils, DeclaredType declaredType) {
        List<DeclaredType> chain = this.findChain(typeUtils, declaredType);
        int lastIndex = chain.size() - 1;
        String typeName = "";
        List<? extends TypeMirror> typeArguments = chain.get(lastIndex).getTypeArguments();
        if (typeArguments.isEmpty()) {
            return null;
        }
        if (typeArguments.get(this.interestedTypeArgumentIndex).getKind() == TypeKind.TYPEVAR) {
            typeName = ((TypeVariable)typeArguments.get(this.interestedTypeArgumentIndex)).asElement().getSimpleName().toString();
        } else if (typeArguments.get(this.interestedTypeArgumentIndex).getKind() == TypeKind.DECLARED) {
            return typeArguments.get(0);
        }
        while (lastIndex > 0) {
            List<? extends TypeParameterElement> typeParameters;
            int typeIndex;
            List<? extends TypeMirror> tArguments;
            TypeMirror matchedType;
            if ((matchedType = (tArguments = chain.get(--lastIndex).getTypeArguments()).get(typeIndex = this.getTypeIndexWithName(typeName, typeParameters = ((TypeElement)chain.get(lastIndex).asElement()).getTypeParameters()))).getKind() == TypeKind.TYPEVAR) {
                typeName = ((TypeVariable)matchedType).asElement().getSimpleName().toString();
                continue;
            }
            if (matchedType.getKind() != TypeKind.DECLARED) continue;
            return matchedType;
        }
        return null;
    }

    private int getTypeIndexWithName(String typeName, List<? extends TypeParameterElement> typeParameters) {
        return IntStream.range(0, typeParameters.size()).filter(i -> ((TypeParameterElement)typeParameters.get(i)).getSimpleName().toString().equals(typeName)).findFirst().orElseThrow();
    }

    private List<DeclaredType> findChain(Types typeUtils, DeclaredType declaredType) {
        ArrayList<DeclaredType> result = new ArrayList<DeclaredType>();
        result.add(declaredType);
        TypeElement superElement = (TypeElement)declaredType.asElement();
        DeclaredType superclass = (DeclaredType)superElement.getSuperclass();
        ArrayList<DeclaredType> matchingInterfaces = this.getMatchingInterfaces(typeUtils, superElement);
        if (matchingInterfaces.size() > 0) {
            result.addAll(matchingInterfaces);
            return result;
        }
        while (superclass.getKind() != TypeKind.NONE) {
            ArrayList<DeclaredType> ifs;
            if (typeUtils.isAssignable(superclass, this.interestedClass)) {
                result.add(superclass);
            }
            if ((ifs = this.getMatchingInterfaces(typeUtils, superElement = (TypeElement)superclass.asElement())).size() > 0) {
                result.addAll(ifs);
                return result;
            }
            if (superElement.getSuperclass().getKind() == TypeKind.NONE) break;
            superclass = (DeclaredType)superElement.getSuperclass();
        }
        return result;
    }

    private ArrayList<DeclaredType> getMatchingInterfaces(Types typeUtils, TypeElement superElement) {
        ArrayList<DeclaredType> result = new ArrayList<DeclaredType>();
        List matchedInterfaces = superElement.getInterfaces().stream().filter(intface -> typeUtils.isAssignable((TypeMirror)intface, this.interestedClass)).map(i -> (DeclaredType)i).collect(Collectors.toList());
        if (matchedInterfaces.size() > 0) {
            result.addAll(matchedInterfaces);
            DeclaredType lastFoundInterface = result.get(result.size() - 1);
            List<DeclaredType> marchingInterfaces = this.findChainOfInterfaces(typeUtils, lastFoundInterface);
            result.addAll(marchingInterfaces);
        }
        return result;
    }

    private List<DeclaredType> findChainOfInterfaces(Types typeUtils, DeclaredType parentInterface) {
        ArrayList<DeclaredType> result = new ArrayList<DeclaredType>();
        List matchingInterfaces = ((TypeElement)parentInterface.asElement()).getInterfaces().stream().filter(i -> typeUtils.isAssignable((TypeMirror)i, this.interestedClass)).map(i -> (DeclaredType)i).collect(Collectors.toList());
        while (matchingInterfaces.size() > 0) {
            result.addAll(matchingInterfaces);
            DeclaredType lastFoundInterface = (DeclaredType)matchingInterfaces.get(matchingInterfaces.size() - 1);
            matchingInterfaces = ((TypeElement)lastFoundInterface.asElement()).getInterfaces().stream().filter(i -> typeUtils.isAssignable((TypeMirror)i, this.interestedClass)).map(i -> (DeclaredType)i).collect(Collectors.toList());
        }
        return result;
    }
}

