/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.server;

import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.Messages;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.BitbucketServerApi;
import io.jenkins.blueocean.commons.DigestUtils;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmServerEndpoint;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.verb.DELETE;
import org.kohsuke.stapler.verb.GET;

public class BitbucketServerEndpoint
extends ScmServerEndpoint {
    private final String id;
    private final Link self;
    private final String apiUrl;
    private final String name;

    public BitbucketServerEndpoint(AbstractBitbucketEndpoint endpoint, Reachable parent) {
        this.id = DigestUtils.sha256Hex((String)endpoint.getServerUrl());
        this.apiUrl = endpoint.getServerUrl();
        this.name = StringUtils.isBlank((String)endpoint.getDisplayName()) ? endpoint.getServerUrl() : endpoint.getDisplayName();
        this.self = parent.getLink().rel(this.id);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public Link getLink() {
        return this.self;
    }

    @GET
    @WebMethod(name={"validate"})
    public HttpResponse validate() {
        String version = BitbucketServerApi.getVersion(this.apiUrl);
        if (!BitbucketServerApi.isSupportedVersion(version)) {
            throw new ServiceException.PreconditionRequired(Messages.bbserver_version_validation_error(version, BitbucketServerApi.MINIMUM_SUPPORTED_VERSION));
        }
        return (req, rsp, node) -> rsp.setStatus(200);
    }

    @WebMethod(name={""})
    @DELETE
    public void doDelete(StaplerResponse resp) {
        BitbucketEndpointConfiguration config = BitbucketEndpointConfiguration.get();
        config.removeEndpoint(this.getApiUrl());
        resp.setStatus(204);
    }
}

