'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.NotFound = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Fullscreen = require('./Fullscreen');

var _reactRouter = require('react-router');

var _i18n = require('./i18n/i18n');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var translate = (0, _i18n.i18nTranslator)('blueocean-web');

/**
 * Simple component to render a fullscreen 404 page
 */
var NotFound = exports.NotFound = function NotFound() {
    return _react2.default.createElement(
        _Fullscreen.Fullscreen,
        { className: 'errorscreen not-found' },
        _react2.default.createElement(
            'div',
            { className: 'message-box' },
            _react2.default.createElement(
                'h3',
                null,
                translate('Not.found.heading', {
                    defaultValue: 'Page not found (404)'
                })
            ),
            _react2.default.createElement(
                'div',
                { className: 'message' },
                translate('Not.found.message', {
                    defaultValue: 'Jenkins could not find the page you were looking for. Check the URL for errors or press the back button.'
                })
            ),
            _react2.default.createElement(
                'div',
                { className: 'actions' },
                _react2.default.createElement(
                    _reactRouter.Link,
                    { to: '/', className: 'btn' },
                    translate('Open.dashboard', { defaultValue: 'Open Dashboard' })
                )
            )
        )
    );
};
//# sourceMappingURL=NotFound.js.map
