'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ReplayButton = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _designLanguage = require('@jenkins-cd/design-language');

var _ = require('../');

var _ToastUtils = require('../ToastUtils');

var _security = require('../security');

var _utils = require('../utils');

var _i18n = require('../i18n/i18n');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Created by cmeyers on 8/30/16.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var permit = _security.Security.permit;

var translate = (0, _i18n.i18nTranslator)('blueocean-web');

function isRunFinished(run) {
    return !!(run && run.state === 'FINISHED');
}

/**
 * ReplayButton allows a pipeline or branch to be re-run when in a failure state.
 */

var ReplayButton = exports.ReplayButton = function (_Component) {
    _inherits(ReplayButton, _Component);

    function ReplayButton(props) {
        _classCallCheck(this, ReplayButton);

        var _this = _possibleConstructorReturn(this, (ReplayButton.__proto__ || Object.getPrototypeOf(ReplayButton)).call(this, props));

        _this.state = {
            replaying: false
        };
        return _this;
    }

    _createClass(ReplayButton, [{
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            var statusChanged = isRunFinished(this.props.latestRun) !== isRunFinished(nextProps.latestRun);

            if (statusChanged) {
                this.setState({
                    replaying: false
                });
            }
        }
    }, {
        key: '_onReplayClick',
        value: function _onReplayClick() {
            var _this2 = this;

            if (this.state.replaying) {
                return;
            }

            this.setState({
                replaying: true
            });

            _.RunApi.replayRun(this.props.latestRun).then(function (run) {
                return _ToastUtils.ToastUtils.createRunStartedToast(_this2.props.runnable, run, _this2.props.onNavigation);
            }).then(function (runDetailsUrl) {
                return _this2._afterReplayStarted(runDetailsUrl);
            });
        }
    }, {
        key: '_afterReplayStarted',
        value: function _afterReplayStarted(runDetailsUrl) {
            if (this.props.autoNavigate && this.props.onNavigation) {
                this.props.onNavigation(runDetailsUrl);
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var _this3 = this;

            if (!this.props.runnable || !this.props.latestRun) {
                return null;
            }

            var outerClass = this.props.className ? this.props.className : '';
            var outerClassNames = outerClass.split(' ');
            var innerButtonClass = outerClassNames.indexOf('icon-button') === -1 ? 'btn inverse' : '';

            var isFinished = isRunFinished(this.props.latestRun);
            var isReplayable = this.props.latestRun.replayable;
            var hasPermission = permit(this.props.runnable).start();

            var replayLabel = translate('run.rerun');

            if (!isFinished || !isReplayable || !hasPermission) {
                return null;
            }

            return _react2.default.createElement(
                'div',
                { className: 'replay-button-component ' + outerClass, onClick: function onClick(event) {
                        return (0, _utils.stopProp)(event);
                    } },
                _react2.default.createElement(
                    'a',
                    { className: 'replay-button ' + innerButtonClass, title: replayLabel, onClick: function onClick() {
                            return _this3._onReplayClick();
                        } },
                    _react2.default.createElement(_designLanguage.Icon, { size: 24, icon: 'AvReplay' }),
                    _react2.default.createElement(
                        'span',
                        { className: 'button-label' },
                        replayLabel
                    )
                )
            );
        }
    }]);

    return ReplayButton;
}(_react.Component);

ReplayButton.propTypes = {
    className: _react.PropTypes.string,
    runnable: _react.PropTypes.object,
    latestRun: _react.PropTypes.object,
    autoNavigate: _react.PropTypes.bool,
    onNavigation: _react.PropTypes.func
};
//# sourceMappingURL=ReplayButton.js.map
