'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TimeHarmonizer = exports.TimeHarmonizerUtil = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _TimeManager = require('../utils/TimeManager');

var _logging = require('../logging');

var _i18n = require('../i18n/i18n');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function jobStillActive(status) {
    switch (String(status).toUpperCase()) {
        case 'RUNNING':
        case 'PAUSED':
        case 'QUEUED':
            return true;
        default:
            return false;
    }
}

var TimeHarmonizerUtil =
// Construct with the owning component for access to props / context
exports.TimeHarmonizerUtil = function TimeHarmonizerUtil(owner) {
    var _this = this;

    _classCallCheck(this, TimeHarmonizerUtil);

    this.getSkewMillis = function () {
        var ctx = _this.owner.context;
        return ctx && ctx.config ? ctx.config.getServerBrowserTimeSkewMillis() : 0;
    };

    this.getDuration = function () {
        return _this.getTimes(_this.owner.props).durationInMillis;
    };

    this.getTimes = function (_ref) {
        var result = _ref.result,
            startTime = _ref.startTime,
            durationInMillis = _ref.durationInMillis,
            endTime = _ref.endTime;

        if (!startTime) {
            return {};
        }

        // we need to make sure that we calculate with the correct time offset
        return TimeHarmonizerUtil.timeManager.harmonizeTimes({
            startTime: startTime,
            endTime: endTime,
            durationInMillis: durationInMillis,
            isRunning: jobStillActive(result)
        }, _this.getSkewMillis());
    };

    this.getI18nTitle = function (result) {
        var durationInMillis = _this.getDuration(result);
        var i18nDuration = TimeHarmonizerUtil.timeManager.format(durationInMillis, TimeHarmonizerUtil.translate('common.date.duration.hint.format', { defaultValue: 'M [month], d [days], h[h], m[m], s[s]' }));

        var title = TimeHarmonizerUtil.translate('common.state.' + result.toLowerCase(), { 0: i18nDuration });
        return title;
    };

    this.owner = owner;
}

// Current server skew
;

TimeHarmonizerUtil.timeManager = new _TimeManager.TimeManager();
TimeHarmonizerUtil.translate = (0, _i18n.i18nTranslator)('blueocean-web');
TimeHarmonizerUtil.logger = _logging.logging.logger('io.jenkins.blueocean.core.TimeHarmonizer');

/**
 * Replicate the functionality of the old wrapper component using the isolated library class
 * @param ComposedComponent
 * @return {NewComponent}
 * @constructor
 */
var TimeHarmonizer = exports.TimeHarmonizer = function TimeHarmonizer(ComposedComponent) {
    var NewComponent = function (_Component) {
        _inherits(NewComponent, _Component);

        function NewComponent() {
            _classCallCheck(this, NewComponent);

            return _possibleConstructorReturn(this, (NewComponent.__proto__ || Object.getPrototypeOf(NewComponent)).apply(this, arguments));
        }

        _createClass(NewComponent, [{
            key: 'componentWillMount',
            value: function componentWillMount() {
                this.timeHarmonizerUtil = new TimeHarmonizerUtil(this);
            }
        }, {
            key: 'render',
            value: function render() {
                var util = this.timeHarmonizerUtil;
                var result = this.props.result;


                var childProps = _extends({}, this.props, {
                    getTimes: util.getTimes,
                    getDuration: util.getDuration,
                    getI18nTitle: util.getI18nTitle
                });

                if (result) {
                    childProps.isRunning = jobStillActive(result);
                }

                // create a composedComponent and inject the functions we want to expose
                return _react2.default.createElement(ComposedComponent, childProps);
            }
        }]);

        return NewComponent;
    }(_react.Component);

    NewComponent.composedComponent = ComposedComponent;

    NewComponent.propTypes = _extends({}, ComposedComponent.propTypes, {
        result: _react.PropTypes.string,
        startTime: _react.PropTypes.string,
        endTime: _react.PropTypes.string,
        durationInMillis: _react.PropTypes.number
    });

    NewComponent.contextTypes = _extends({}, ComposedComponent.contextTypes, {
        config: _react.PropTypes.object.isRequired
    });

    return NewComponent;
};
//# sourceMappingURL=TimeHarmonizer.js.map
