'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _BlueLogo = require('../BlueLogo');

var _ContentPageHeader = require('../ContentPageHeader');

var _ResultPageHeader = require('../ResultPageHeader');

var _designLanguage = require('@jenkins-cd/design-language');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('Headers', module).add('Logo', logo).add('Site Header (link)', siteHeaderLink).add('Dashboard', pageHeaderDashboard).add('Pipeline', pageHeaderPipeline).add('Result', pageHeaderResult); /* eslint-disable */

function logo() {
    return _react2.default.createElement(
        'section',
        null,
        _react2.default.createElement(
            'h1',
            null,
            '100%'
        ),
        _react2.default.createElement(
            'div',
            { style: { display: 'flex', background: '#3a70b0', padding: '3em' } },
            _react2.default.createElement(_BlueLogo.BlueLogo, null)
        ),
        _react2.default.createElement(
            'p',
            null,
            '\xA0'
        ),
        _react2.default.createElement(
            'h1',
            null,
            '300%'
        ),
        _react2.default.createElement(
            'div',
            { style: { display: 'flex', background: '#444', padding: '1em', zoom: '300%' } },
            _react2.default.createElement(_BlueLogo.BlueLogo, null)
        )
    );
}

function pageHeaderDashboard() {
    var topNavLinks = [_react2.default.createElement(
        'a',
        { href: '#', className: 'selected' },
        'Pipelines'
    ), _react2.default.createElement(
        'a',
        { href: '#' },
        'Applications'
    ), _react2.default.createElement(
        'a',
        { href: '#' },
        'Reports'
    ), _react2.default.createElement(
        'a',
        { href: '#' },
        'Administration'
    )];

    var userComponents = [_react2.default.createElement(
        'button',
        { className: 'btn-sign-in' },
        'Sign in'
    ), _react2.default.createElement(
        'button',
        { className: 'btn-sign-up' },
        'Sign up'
    )];

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(_ContentPageHeader.SiteHeader, { topNavLinks: topNavLinks, userComponents: userComponents }),
        _react2.default.createElement(
            _ContentPageHeader.ContentPageHeader,
            null,
            _react2.default.createElement(
                'h1',
                null,
                'Dashboard'
            )
        )
    );
}

function pageHeaderPipeline() {
    var topNavLinks = [_react2.default.createElement(
        'a',
        { href: '#', className: 'selected' },
        'Pipelines'
    ), _react2.default.createElement(
        'a',
        { href: '#' },
        'Applications'
    ), _react2.default.createElement(
        'a',
        { href: '#' },
        'Reports'
    ), _react2.default.createElement(
        'a',
        { href: '#' },
        'Administration'
    )];

    var pageTabLinks = [_react2.default.createElement(
        'a',
        { href: '#', className: 'selected' },
        'Activity'
    ), _react2.default.createElement(
        'a',
        { href: '#' },
        'Branches'
    ), _react2.default.createElement(
        'a',
        { href: '#' },
        'Pull Requests'
    ), _react2.default.createElement(
        'a',
        { href: '#' },
        'Trends'
    )];

    var userComponents = [_react2.default.createElement(
        'button',
        { className: 'btn-sign-in' },
        'Sign in'
    ), _react2.default.createElement(
        'button',
        { className: 'btn-sign-up' },
        'Sign up'
    )];

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(_ContentPageHeader.SiteHeader, { topNavLinks: topNavLinks, userComponents: userComponents }),
        _react2.default.createElement(
            _ContentPageHeader.ContentPageHeader,
            { pageTabLinks: pageTabLinks },
            _react2.default.createElement(_designLanguage.WeatherIcon, { score: 100 }),
            _react2.default.createElement(
                'h1',
                null,
                'Lorem / Ipsum / ',
                _react2.default.createElement(
                    'a',
                    { href: '#' },
                    'Pipelineum'
                )
            )
        )
    );
}

function siteHeaderLink() {
    var topNavLinks = [_react2.default.createElement(
        'a',
        { href: '#', className: 'selected' },
        'Pipelines'
    ), _react2.default.createElement(
        'a',
        { href: '#' },
        'Applications'
    ), _react2.default.createElement(
        'a',
        { href: '#' },
        'Reports'
    ), _react2.default.createElement(
        'a',
        { href: '#' },
        'Administration'
    )];

    var pageTabLinks = [_react2.default.createElement(
        'a',
        { href: '#', className: 'selected' },
        'Activity'
    ), _react2.default.createElement(
        'a',
        { href: '#' },
        'Branches'
    ), _react2.default.createElement(
        'a',
        { href: '#' },
        'Pull Requests'
    ), _react2.default.createElement(
        'a',
        { href: '#' },
        'Trends'
    )];

    var userComponents = [_react2.default.createElement(
        'button',
        { className: 'btn-sign-in' },
        'Sign in'
    ), _react2.default.createElement(
        'button',
        { className: 'btn-sign-up' },
        'Sign up'
    )];

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(_ContentPageHeader.SiteHeader, { topNavLinks: topNavLinks, userComponents: userComponents }),
        _react2.default.createElement('br', null),
        _react2.default.createElement(_ContentPageHeader.SiteHeader, { topNavLinks: topNavLinks, userComponents: userComponents, homeURL: '/' }),
        _react2.default.createElement('br', null),
        _react2.default.createElement(_ContentPageHeader.SiteHeader, { topNavLinks: topNavLinks, userComponents: userComponents, homeURL: '/alpha/bravo' })
    );
}

function pageHeaderResult() {
    return _react2.default.createElement(
        'section',
        null,
        _react2.default.createElement(ExamplePageHeader, { status: 'success' }),
        _react2.default.createElement('br', null),
        _react2.default.createElement(ExamplePageHeader, { status: 'failure' }),
        _react2.default.createElement('br', null),
        _react2.default.createElement(ExamplePageHeader, { status: 'running' }),
        _react2.default.createElement('br', null),
        _react2.default.createElement(ExamplePageHeader, { status: 'queued' }),
        _react2.default.createElement('br', null),
        _react2.default.createElement(ExamplePageHeader, { status: 'unstable' }),
        _react2.default.createElement('br', null),
        _react2.default.createElement(ExamplePageHeader, { status: 'aborted' }),
        _react2.default.createElement('br', null),
        _react2.default.createElement(ExamplePageHeader, { status: 'not_built' }),
        _react2.default.createElement('br', null),
        _react2.default.createElement(ExamplePageHeader, { status: 'paused' }),
        _react2.default.createElement('br', null),
        _react2.default.createElement(ExamplePageHeader, { status: 'unknown' }),
        _react2.default.createElement('br', null)
    );

    function ExamplePageHeader(props) {
        var topNavLinks = [_react2.default.createElement(
            'a',
            { href: '#', className: 'selected' },
            'Pipeline'
        ), _react2.default.createElement(
            'a',
            { href: '#' },
            'Changes'
        ), _react2.default.createElement(
            'a',
            { href: '#' },
            'Tests'
        ), _react2.default.createElement(
            'a',
            { href: '#' },
            'Artifacts'
        )];

        var runButton = [_react2.default.createElement(
            'button',
            { className: 'btn-secondary' },
            'Re-run'
        )];

        var title = _react2.default.createElement(
            'h1',
            null,
            'Lorem / Ipsum / ',
            props.status,
            ' ',
            _react2.default.createElement(
                'a',
                { href: '#' },
                '#211'
            )
        );

        return _react2.default.createElement(
            _ResultPageHeader.ResultPageHeader,
            { status: props.status,
                title: title,
                topNavLinks: topNavLinks,
                runButton: runButton,
                onCloseClick: function onCloseClick() {
                    return console.log('Ouch! Close me!');
                }
            },
            '[ TODO: build details ]'
        );
    }
}
//# sourceMappingURL=ContentPageHeaderStories.js.map
