'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParameterApi = exports.supportedInputTypes = exports.supportedInputTypesMapping = exports.ParametersRunButton = exports.ParameterService = exports.DebugRender = exports.ParametersRender = exports.Password = exports.Text = exports.String = exports.Choice = exports.Boolean = undefined;

var _ParametersRender = require('./renderer/ParametersRender');

Object.defineProperty(exports, 'ParametersRender', {
  enumerable: true,
  get: function get() {
    return _ParametersRender.ParametersRender;
  }
});

var _DebugRender = require('./renderer/DebugRender');

Object.defineProperty(exports, 'DebugRender', {
  enumerable: true,
  get: function get() {
    return _DebugRender.DebugRender;
  }
});

var _ParameterService = require('./services/ParameterService');

Object.defineProperty(exports, 'ParameterService', {
  enumerable: true,
  get: function get() {
    return _ParameterService.ParameterService;
  }
});

var _ParametersRunButton = require('./ParametersRunButton');

Object.defineProperty(exports, 'ParametersRunButton', {
  enumerable: true,
  get: function get() {
    return _ParametersRunButton.ParametersRunButton;
  }
});

var _Boolean = require('./components/Boolean');

var _Choice = require('./components/Choice');

var _String = require('./components/String');

var _Text = require('./components/Text');

var _Password = require('./components/Password');

var _ParameterApi = require('./rest/ParameterApi');

exports.Boolean = _Boolean.Boolean;
exports.Choice = _Choice.Choice;
exports.String = _String.String;
exports.Text = _Text.Text;
exports.Password = _Password.Password;
// Renderer
// Implementations

/**
 * all input types that we know of mapping against the component
 * @type {{BooleanParameterDefinition: Boolean, ChoiceParameterDefinition: Choice, TextParameterDefinition: String, StringParameterDefinition: Text, PasswordParameterDefinition: Password, GitParameterDefinition: Text}}
 */
var supportedInputTypesMapping = exports.supportedInputTypesMapping = {
  BooleanParameterDefinition: _Boolean.Boolean,
  ChoiceParameterDefinition: _Choice.Choice,
  TextParameterDefinition: _Text.Text,
  StringParameterDefinition: _String.String,
  PasswordParameterDefinition: _Password.Password,
  GitParameterDefinition: _String.String
};
/**
 * all input types that we know of
 * @type {Array}
 */
var supportedInputTypes = exports.supportedInputTypes = Object.keys(supportedInputTypesMapping);

var parameterApi = new _ParameterApi.ParameterApi();
exports.ParameterApi = parameterApi;
//# sourceMappingURL=index.js.map
