'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ToastUtils = undefined;

var _ = require('./');

var _UrlBuilder = require('./UrlBuilder');

var _i18n = require('./i18n/i18n');

var ToastUtils = exports.ToastUtils = {
    /**
     *
     * @param runnable
     * @param run
     * @param toastAction
     */
    createRunStartedToast: function createRunStartedToast(runnable, run, toastAction) {
        var translate = (0, _i18n.i18nTranslator)('blueocean-web');

        var runId = run.id;

        var runDetailsUrl = (0, _UrlBuilder.buildRunUrlForDetails)(run);

        var name = decodeURIComponent(runnable.name);
        var text = translate('toast.run.started', {
            0: name,
            1: runId,
            defaultValue: 'Started "{0}" #{1}'
        });

        var caption = translate('toast.run.open', {
            defaultValue: 'Open'
        });
        _.ToastService.newToast({
            text: text,
            action: caption,
            onActionClick: function onActionClick() {
                if (toastAction) {
                    toastAction(runDetailsUrl);
                }
            }
        });

        return runDetailsUrl;
    }
}; /**
    * Created by cmeyers on 9/21/16.
    */
//# sourceMappingURL=ToastUtils.js.map
