'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.AnalyticsService = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _fetch = require('../fetch');

var _urlconfig = require('../urlconfig');

var _utils = require('../utils');

var _config = require('../config');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var AnalyticsService = exports.AnalyticsService = function () {
    function AnalyticsService() {
        _classCallCheck(this, AnalyticsService);
    }

    _createClass(AnalyticsService, [{
        key: 'track',
        value: function track(eventName, properties) {
            // Don't scare anyone by posting back stats tracking when usage stats are off
            if (!_config.AppConfig.getAnalyticsEnabled()) return false;

            // Go ahead and record usage stats
            var path = _urlconfig.UrlConfig.getJenkinsRootURL();
            var url = _utils.Utils.cleanSlashes(path + '/blue/rest/analytics/track');
            var fetchOptions = {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    name: eventName,
                    properties: properties
                })
            };
            return _fetch.Fetch.fetch(url, { fetchOptions: fetchOptions });
        }
    }]);

    return AnalyticsService;
}();
//# sourceMappingURL=AnalyticsService.js.map
