'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.CapabilityApi = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Created by cmeyers on 9/8/16.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _fetch = require('../fetch');

var _urlconfig = require('../urlconfig');

var _utils = require('../utils');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var CapabilityApi = exports.CapabilityApi = function () {
    function CapabilityApi() {
        _classCallCheck(this, CapabilityApi);
    }

    _createClass(CapabilityApi, [{
        key: 'fetchCapabilities',

        /**
         * Fetch the capabilities for one or more class names.
         *
         * @param {Array} classNames
         * @returns {Promise} with fulfilled {object} keyed by className, with an array of string capability names.
         * @private
         */
        value: function fetchCapabilities(classNames) {
            var noDuplicates = classNames.filter(function (item, index, self) {
                return self.indexOf(item) === index;
            });
            var path = _urlconfig.UrlConfig.getJenkinsRootURL();
            var classesUrl = _utils.Utils.cleanSlashes(path + '/blue/rest/classes/');

            var fetchOptions = {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ q: noDuplicates })
            };

            return _fetch.Fetch.fetchJSON(classesUrl, { disableCapabilities: true, fetchOptions: fetchOptions });
        }
    }]);

    return CapabilityApi;
}();
//# sourceMappingURL=CapabilityApi.js.map
