'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.LoginButton = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _index = require('../index');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * LoginButton to login/logout.
 */
var LoginButton = exports.LoginButton = function (_Component) {
    _inherits(LoginButton, _Component);

    function LoginButton() {
        _classCallCheck(this, LoginButton);

        return _possibleConstructorReturn(this, (LoginButton.__proto__ || Object.getPrototypeOf(LoginButton)).apply(this, arguments));
    }

    _createClass(LoginButton, [{
        key: 'render',
        value: function render() {
            if (!_index.Security.isSecurityEnabled()) {
                return null;
            }

            var action = void 0;
            var url = void 0;
            if (_index.Security.isAnonymousUser()) {
                action = 'login';
                url = _index.UrlConfig.getJenkinsRootURL() + '/' + _index.AppConfig.getLoginUrl() + '?from=' + encodeURIComponent(_index.Utils.windowOrGlobal().location.pathname);
            } else {
                action = 'logout';
                url = _index.UrlConfig.getJenkinsRootURL() + '/logout';
            }
            return _react2.default.createElement(
                'div',
                { className: this.props.className },
                _react2.default.createElement(
                    'a',
                    { href: url, className: 'btn-link' },
                    this.props.translate(action, { defaultValue: action })
                )
            );
        }
    }]);

    return LoginButton;
}(_react.Component);

LoginButton.propTypes = {
    className: _react.PropTypes.string,
    translate: _react.PropTypes.func
};
//# sourceMappingURL=LoginButton.js.map
