'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ResultPageHeader = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _designLanguage = require('@jenkins-cd/design-language');

var _ContentPageHeader = require('./ContentPageHeader');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Exported from Zeplin, path could use a little cleanup
var CloseButton = function CloseButton(props) {
    return _react2.default.createElement(
        'span',
        { title: props.t('creation.core.header.close', { defaultValue: 'Close' }) },
        _react2.default.createElement(
            'svg',
            { className: 'ResultPageHeader-close', width: '24px', height: '24px', viewBox: '0 0 24 24', onClick: props.onClick, version: '1.1' },
            _react2.default.createElement(
                'g',
                { strokeWidth: '1' },
                _react2.default.createElement('polygon', { points: '19 6.415 17.585 5 12 10.585 6.415 5 5 6.415 10.585 12 5 17.585 6.415 19 12 13.415 17.585 19 19 17.585 13.415 12' })
            )
        )
    );
};

CloseButton.propTypes = {
    onClick: _react.PropTypes.func,
    t: _react.PropTypes.func
};

var ResultPageHeader = exports.ResultPageHeader = function ResultPageHeader(props) {
    var _props$status = props.status,
        status = _props$status === undefined ? 'unknown' : _props$status,
        title = props.title,
        onCloseClick = props.onCloseClick,
        startTime = props.startTime,
        estimatedDurationInMillis = props.estimatedDurationInMillis,
        t = props.t;


    var closeClicked = function closeClicked() {
        if (onCloseClick) {
            onCloseClick();
        }
    };

    var titleComp = (0, _ContentPageHeader._wrap)(title, 'div', { className: 'ResultPageHeader-title u-flex-grow' });
    var topNavLinks = (0, _ContentPageHeader._wrap)(props.topNavLinks, 'nav');
    var runButton = (0, _ContentPageHeader._wrap)(props.runButton, 'div', { className: 'ResultPageHeader-run' });

    var classNames = ['ResultPageHeader'];
    if (props.className) {
        classNames.push(props.className);
    }

    return _react2.default.createElement(
        _designLanguage.BasicHeader,
        { className: classNames.join(' '), statusColor: status },
        _react2.default.createElement(
            _designLanguage.TopNav,
            null,
            _react2.default.createElement(
                'section',
                { className: 'ResultPageHeader-indicator status inverse' },
                _react2.default.createElement(_designLanguage.LiveStatusIndicator, { result: status, startTime: startTime, estimatedDuration: estimatedDurationInMillis, noBackground: true })
            ),
            titleComp,
            topNavLinks,
            runButton,
            _react2.default.createElement(CloseButton, { onClick: closeClicked, t: t })
        ),
        _react2.default.createElement(
            _designLanguage.HeaderDetails,
            null,
            _react2.default.createElement(
                'div',
                { className: 'ResultPageHeader-main u-flex-grow' },
                props.children
            )
        )
    );
};

ResultPageHeader.propTypes = {
    className: _react.PropTypes.string,
    children: _react.PropTypes.node,
    status: _react.PropTypes.string,
    onCloseClick: _react.PropTypes.func,
    title: _react.PropTypes.node,
    topNavLinks: _react.PropTypes.node,
    runButton: _react.PropTypes.node,
    startTime: _react.PropTypes.string,
    estimatedDurationInMillis: _react.PropTypes.number,
    t: _react.PropTypes.func
};
//# sourceMappingURL=ResultPageHeader.js.map
