'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ParametersRunButton = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _designLanguage = require('@jenkins-cd/design-language');

var _index = require('../index');

var _i18n = require('../i18n/i18n');

var _index2 = require('./index');

var _logging = require('../logging');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var logger = _logging.logging.logger('io.jenkins.blueocean.core.ParametersRunButton');

/**
 * Translate function
 */
var t = (0, _i18n.i18nTranslator)('blueocean-web');
var MULTIBRANCH_PIPELINE = 'io.jenkins.blueocean.rest.model.BlueMultiBranchPipeline';
/**
 * Creating a "<form/>"less form to submit the build parameters requested by the user for a parameterized job..
 *
 * We keep all form data in the ParameterService and change them onChange and onToggle (depending of the parameter
 * type). We match the different supported inputTypes with a mapping functions
 * @see supportedInputTypesMapping
 * That mapping delegates to the specific implementation where we further delegate to JDL components.
 * In case you want to register a new mapping you need to edit './parameter/index' to add a new mapping
 * and further in './parameter/commonProptypes' you need to include the new type in the oneOf array.
 */

var ParametersRunButton = exports.ParametersRunButton = function (_Component) {
    _inherits(ParametersRunButton, _Component);

    function ParametersRunButton(props) {
        _classCallCheck(this, ParametersRunButton);

        var _this = _possibleConstructorReturn(this, (ParametersRunButton.__proto__ || Object.getPrototypeOf(ParametersRunButton)).call(this, props));

        _this.state = {};

        if (props.runnable && props.runnable.parameters) {
            var parameters = props.runnable.parameters;

            _this.parameterService = new _index2.ParameterService();
            _this.parameterService.init(parameters);
        } else {
            _this.parameterService = { parameters: [] };
        }
        return _this;
    }
    // we start with an empty state


    _createClass(ParametersRunButton, [{
        key: 'componentWillMount',

        /**
         * react life cycle mapper to invoke the creation of the form state
         */
        value: function componentWillMount() {
            this.createFormState(this.props);
        }
        /**
         * react life cycle mapper to invoke the update of the service
         */

    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            if (nextProps.runnable && nextProps.runnable.parameters && this.props.runnable && this.props.runnable.parameters && nextProps.runnable.parameters !== this.props.runnable.parameters) {
                this.parameterService.init(nextProps.runnable.parameters);
            }
        }
        /**
         * Create some information for form handling
         * @param props
         */

    }, {
        key: 'createFormState',
        value: function createFormState(props) {
            var runnable = props.runnable;

            if (runnable) {
                var _context$config = this.context.config,
                    config = _context$config === undefined ? {} : _context$config;
                var href = runnable._links.self.href;

                this.setState({
                    href: '' + config._rootURL + href + '/runs/',
                    visible: false
                });
            }
        }
        /**
         * Hide the dialog / Submit the form as "cancel"
         */

    }, {
        key: 'hide',
        value: function hide() {
            this.setState({ visible: false });
        }
        /**
         * Show the dialog
         */

    }, {
        key: 'show',
        value: function show() {
            this.setState({ visible: true });
        }
        /**
         * Submit the form out of the data parameters and create a Toast
         */

    }, {
        key: 'initializeBuild',
        value: function initializeBuild() {
            var _this2 = this;

            var parameters = this.parameterService.parametersToSubmitArray();
            _index2.ParameterApi.startRunWithParameters(this.state.href, parameters).then(function (run) {
                _index.ToastUtils.createRunStartedToast(_this2.props.runnable, run, _this2.props.onNavigation);
            });
            return this.hide();
        }
    }, {
        key: 'render',
        value: function render() {
            var _this3 = this;

            var parameters = this.parameterService.parameters;

            // Captions

            var message = t('parameterized.pipeline.header', { defaultValue: 'Input required' });
            var ok = t('parameterized.pipeline.submit', { defaultValue: 'Run' });
            var cancelCaption = t('parameterized.pipeline.cancel', { defaultValue: 'Cancel' });
            // buttons
            var cancelButton = _react2.default.createElement(
                'button',
                { title: cancelCaption, onClick: function onClick() {
                        return _this3.hide();
                    }, className: 'btn inputStepCancel run-button btn-secondary' },
                _react2.default.createElement(
                    'span',
                    { className: 'button-label' },
                    cancelCaption
                )
            );
            var okButton = _react2.default.createElement(
                'button',
                { title: ok, onClick: function onClick() {
                        return _this3.initializeBuild();
                    }, className: 'btn inputStepSubmit' },
                _react2.default.createElement(
                    'span',
                    { className: 'button-label' },
                    ok
                )
            );
            // common run properties
            var runButtonProps = _extends({}, this.props);
            // when we have build parameters we need to show them before trigger a build
            if (parameters.length > 0 && runButtonProps.buttonType !== 'stop-only') {
                runButtonProps.onClick = function () {
                    _this3.show();
                };
            }
            var isMultiBranch = (0, _index.capable)(this.props.runnable, MULTIBRANCH_PIPELINE);
            var pipe = { fullName: this.props.runnable.fullName };
            if (isMultiBranch) {
                pipe.fullName += '/' + pipe.branch;
            }
            var classicBuildUrl = _index.UrlBuilder.buildClassicBuildUrl(pipe);
            var sanity = parameters.filter(function (parameter) {
                return _index2.supportedInputTypesMapping[parameter.type] !== undefined;
            });
            logger.debug('sane?', sanity.length === parameters.length, 'classicBuildUrl: ', classicBuildUrl);
            var dialog = void 0;
            if (sanity.length !== parameters.length) {
                logger.debug('sanity check failed. Returning Alert instead of the form.');
                var alertCaption = [_react2.default.createElement(
                    'p',
                    null,
                    t('inputParameter.error.message')
                ), _react2.default.createElement(
                    'a',
                    { href: classicBuildUrl, target: '_blank' },
                    t('inputParameter.error.linktext')
                )];
                var alertTitle = t('inputParameter.error.title', { defaultValue: 'Error' });
                dialog = _react2.default.createElement(
                    _designLanguage.Dialog,
                    { onDismiss: this.hide.bind(this), title: message, className: 'Dialog--input' },
                    _react2.default.createElement(_designLanguage.Alerts, { message: alertCaption, type: 'Error', title: alertTitle })
                );
            } else {
                dialog = _react2.default.createElement(
                    _designLanguage.Dialog,
                    { buttons: [okButton, cancelButton], onDismiss: this.hide.bind(this), title: message, className: 'Dialog--input Dialog--medium-size' },
                    _react2.default.createElement(_index2.ParametersRender, { parameters: parameters, onChange: function onChange(index, newValue) {
                            return _this3.parameterService.changeParameter(index, newValue);
                        } })
                );
            }
            return _react2.default.createElement(
                'div',
                { className: 'ParametersRunButton' },
                _react2.default.createElement(_index.RunButtonBase, runButtonProps),
                this.state.visible && _react2.default.createElement(
                    'div',
                    { className: 'inputParameters' },
                    dialog
                )
            );
        }
    }]);

    return ParametersRunButton;
}(_react.Component);

var bool = _react.PropTypes.bool,
    func = _react.PropTypes.func,
    object = _react.PropTypes.object,
    oneOf = _react.PropTypes.oneOf,
    string = _react.PropTypes.string;


ParametersRunButton.propTypes = {
    visible: bool,
    onNavigation: func,
    runnable: object,
    latestRun: object,
    buttonType: oneOf(['toggle', 'stop-only', 'run-only']),
    className: string,
    onClick: func,
    runText: string,
    innerButtonClasses: string
};

ParametersRunButton.contextTypes = {
    config: object.isRequired
};
//# sourceMappingURL=ParametersRunButton.js.map
