'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Choice = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _designLanguage = require('@jenkins-cd/design-language');

var _commonProptypes = require('../commonProptypes');

var _stringUtil = require('../../stringUtil');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Choice = exports.Choice = function (_Component) {
    _inherits(Choice, _Component);

    function Choice() {
        _classCallCheck(this, Choice);

        return _possibleConstructorReturn(this, (Choice.__proto__ || Object.getPrototypeOf(Choice)).apply(this, arguments));
    }

    _createClass(Choice, [{
        key: 'radioOrDropDown',

        /**
         * Choose whether to show a dropdown choice or a radioButtonGroup
         * @param choices - alternatives we can present
         */
        value: function radioOrDropDown(choices) {
            if (choices.length > 6) {
                return _designLanguage.Dropdown;
            }
            return _designLanguage.RadioButtonGroup;
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                value = _props.defaultParameterValue.value,
                description = _props.description,
                name = _props.name,
                choices = _props.choices,
                onChange = _props.onChange;

            var uxChoice = this.radioOrDropDown(choices);
            var cleanName = (0, _stringUtil.removeMarkupTags)(name);
            var cleanDescription = (0, _stringUtil.removeMarkupTags)(description);
            var options = {
                defaultOption: value,
                options: choices,
                name: cleanName,
                onChange: onChange
            };
            // css tweaks
            var className = 'Choice';
            var formProperties = { title: cleanDescription };
            if (choices.length > 6) {
                className += ' FullWidth';
            } else {
                className += ' underline';
            }
            formProperties.className = className;

            return _react2.default.createElement(
                _designLanguage.FormElement,
                formProperties,
                _react2.default.createElement(uxChoice, _extends({}, options))
            );
        }
    }]);

    return Choice;
}(_react.Component);
// <Dropdown {...options} />
// extending the common propType since we have additional properties
// const choicePropTypes = propTypes;
// choicePropTypes.parameters.choices = PropTypes.array;


Choice.propTypes = _commonProptypes.propTypes;
//# sourceMappingURL=Choice.js.map
