'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ParameterService = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _desc, _value, _class, _descriptor;

var _mobx = require('mobx');

function _initDefineProp(target, property, descriptor, context) {
    if (!descriptor) return;
    Object.defineProperty(target, property, {
        enumerable: descriptor.enumerable,
        configurable: descriptor.configurable,
        writable: descriptor.writable,
        value: descriptor.initializer ? descriptor.initializer.call(context) : void 0
    });
}

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
    var desc = {};
    Object['ke' + 'ys'](descriptor).forEach(function (key) {
        desc[key] = descriptor[key];
    });
    desc.enumerable = !!desc.enumerable;
    desc.configurable = !!desc.configurable;

    if ('value' in desc || desc.initializer) {
        desc.writable = true;
    }

    desc = decorators.slice().reverse().reduce(function (desc, decorator) {
        return decorator(target, property, desc) || desc;
    }, desc);

    if (context && desc.initializer !== void 0) {
        desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
        desc.initializer = undefined;
    }

    if (desc.initializer === void 0) {
        Object['define' + 'Property'](target, property, desc);
        desc = null;
    }

    return desc;
}

function _initializerWarningHelper(descriptor, context) {
    throw new Error('Decorating class property failed. Please ensure that transform-class-properties is enabled.');
}

/**
 * Holds one or more parameters in state for display in UI.
 */
var ParameterService = exports.ParameterService = (_class = function () {
    function ParameterService() {
        _classCallCheck(this, ParameterService);

        _initDefineProp(this, 'parameters', _descriptor, this);
    }

    _createClass(ParameterService, [{
        key: 'init',


        /**
         * initialize array from parameters.
         * @param parameters - array of parameter
         */
        value: function init(parameters) {
            this.parameters = parameters;
        }
        /**
         * Adds a parameter to the list.
         *
         * @param parameter object with the following shape:
         * {
         * "_class": "hudson.model.BooleanParameterDefinition",
         * "defaultParameterValue": {
         *    "_class": "hudson.model.BooleanParameterValue",
         *    "name": "isFoo",
         *    "value": false,
         *    "_capabilities": ["hudson.model.ParameterValue"]
         * },
         * "description": "isFoo should be false",
         * "name": "isFoo",
         * "type": "BooleanParameterDefinition",
         * "_capabilities": ["hudson.model.SimpleParameterDefinition", "hudson.model.ParameterDefinition"]
         * }
         */

    }, {
        key: 'addParameter',
        value: function addParameter(parameter) {
            this.parameters.push(parameter);
        }

        /**
         * Add an array of parameters.
         * @param parameters - array of parameter
         */

    }, {
        key: 'addParameters',
        value: function addParameters(parameters) {
            this.parameters.push.apply(this.parameters, parameters);
        }

        /**
         * Change the defaultValue of an existing parameter
         * @param index - the position of the object
         * @param newValue - the value of the user selection becomes the ne default parameter
         */

    }, {
        key: 'changeParameter',
        value: function changeParameter(index, newValue) {
            this.parameters[index].defaultParameterValue.value = newValue;
        }

        /**
         * Creates an array from the parameter array which is in the current state
         * @returns {array}
         */

    }, {
        key: 'parametersToSubmitArray',
        value: function parametersToSubmitArray() {
            return this.parameters.map(function (item) {
                var parameter = { name: item.name, value: item.defaultParameterValue.value };
                return parameter;
            });
        }
    }, {
        key: 'count',
        get: function get() {
            return this.parameters ? this.parameters.length : 0;
        }
    }]);

    return ParameterService;
}(), (_descriptor = _applyDecoratedDescriptor(_class.prototype, 'parameters', [_mobx.observable], {
    enumerable: true,
    initializer: function initializer() {
        return [];
    }
}), _applyDecoratedDescriptor(_class.prototype, 'init', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'init'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'addParameter', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'addParameter'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'addParameters', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'addParameters'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'changeParameter', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'changeParameter'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'count', [_mobx.computed], Object.getOwnPropertyDescriptor(_class.prototype, 'count'), _class.prototype)), _class);
//# sourceMappingURL=ParameterService.js.map
