'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ActivityService = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _Pager = require('./Pager');

var _rest = require('../paths/rest');

var _fetch = require('../fetch');

var _BunkerService2 = require('./BunkerService');

var _utils = require('../utils');

var _mobxUtils = require('mobx-utils');

var _mobxUtils2 = _interopRequireDefault(_mobxUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/*
 * This class provides activity related services.
 *
 * @export
 * @class ActivityService
 * @extends {BunkerService}
 */
var ActivityService = exports.ActivityService = function (_BunkerService) {
    _inherits(ActivityService, _BunkerService);

    function ActivityService() {
        _classCallCheck(this, ActivityService);

        return _possibleConstructorReturn(this, (ActivityService.__proto__ || Object.getPrototypeOf(ActivityService)).apply(this, arguments));
    }

    _createClass(ActivityService, [{
        key: 'pagerKey',

        /**
         * Generates a pager key for [@link PagerService] to store the [@link Pager] under.
         *
         * @param {string} organization Jenkins organization that this pager belongs to.
         * @param {string} pipeline Pipeline that this pager belongs to.
         * @param {string} branch Optional branch that this pager belongs to.
         * @returns {string} key for [@link PagerService]
         */
        value: function pagerKey(organization, pipeline, branch) {
            return 'Activities/' + organization + '-' + pipeline + '-' + branch;
        }

        /**
         * Gets the activity pager
         *
         * @param {string} organization Jenkins organization that this pager belongs to.
         * @param {string} pipeline Pipeline that this pager belongs to.
         * @returns {Pager} Pager for this pipeline.
         */

    }, {
        key: 'activityPager',
        value: function activityPager(organization, pipeline, branch) {
            var _this2 = this;

            return this.pagerService.getPager({
                key: this.pagerKey(organization, pipeline, branch),
                /**
                 * Lazily generate the pager incase its needed.
                 */
                lazyPager: function lazyPager() {
                    return new _Pager.Pager(_rest.RestPaths.runs(organization, pipeline, branch), 25, _this2);
                }
            });
        }

        /**
         * Gets an activity from the store.
         *
         * @param {string} href Self href for activity.
         * @returns {object} Mobx computed value
         */

    }, {
        key: 'getActivity',
        value: function getActivity(href) {
            return this.getItem(href);
        }
    }, {
        key: 'getTestSummary',
        value: function getTestSummary(href) {
            return this.getItem(href);
        }

        /**
         * Fetches an activity from rest api.
         *
         * Note: This only works for activities that are not in the queue.
         *
         * @param {string} href self href of activity.
         * @param {boolean} useCache Use the cache to lookup data or always fetch a new one.
         * @param {boolean} disableLoadingIndicator Hide the visual progress indicator displayed during fetch.
         * @returns {Promise} Promise of fetched data.
         */

    }, {
        key: 'fetchActivity',
        value: function fetchActivity(href) {
            var _this3 = this;

            var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                useCache = _ref.useCache,
                disableLoadingIndicator = _ref.disableLoadingIndicator;

            if (useCache && this.hasItem(href)) {
                return Promise.resolve(this.getItem(href));
            }
            return _fetch.Fetch.fetchJSON(href, { disableLoadingIndicator: disableLoadingIndicator }).then(function (data) {
                return _this3.setItem(data);
            }).catch(function (err) {
                console.log('There has been an error while trying to get the run data.', err);
            });
        }

        /**
         * Fetch a TestSummary for a run
         *
         * @param href (eg: myRun._links.testSummary.href )
         */

    }, {
        key: 'fetchTestSummary',
        value: function fetchTestSummary(href) {
            var _this4 = this;

            var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                useCache = _ref2.useCache,
                disableLoadingIndicator = _ref2.disableLoadingIndicator;

            if (useCache && this.hasItem(href)) {
                return Promise.resolve(this.getItem(href));
            }

            return _fetch.Fetch.fetchJSON(href, { disableLoadingIndicator: disableLoadingIndicator }).then(function (data) {
                return _this4.setItem(data);
            }).catch(function (err) {
                console.log('There has been an error while trying to get the TestSummary data.', err);
            });
        }

        /**
         * Fetch a pager for changeSet
         *
         * @param href (eg: myRun._links.changeSet.href )
         */

    }, {
        key: 'changeSetPager',
        value: function changeSetPager(href) {
            var _this5 = this;

            return this.pagerService.getPager({
                key: href,
                /**
                 * Lazily generate the pager incase its needed.
                 */
                lazyPager: function lazyPager() {
                    return new _Pager.Pager(href, 100, _this5);
                }
            });
        }

        /**
         * Fetches artifacts for a given run.
         *
         * @param {string} runHref The href of the run to fetcfh artifacts for.
         * @returns {Object} Object containing zipFile link and list of artifacts.
         */

    }, {
        key: 'fetchArtifacts',
        value: function fetchArtifacts(runHref) {
            return _mobxUtils2.default.fromPromise(_fetch.Fetch.fetchJSON(runHref + 'artifacts/?start=0&limit=101'));
        }
    }, {
        key: 'artifactsPager',
        value: function artifactsPager(runHref) {
            var _this6 = this;

            return this.pagerService.getPager({
                key: runHref + 'artifacts/',
                /**
                 * Lazily generate the pager incase its needed.
                 */
                lazyPager: function lazyPager() {
                    return new _Pager.Pager(runHref + 'artifacts/', 100, _this6);
                }
            });
        }
    }]);

    return ActivityService;
}(_BunkerService2.BunkerService);
//# sourceMappingURL=ActivityService.js.map
