'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SSEService = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _utils = require('../utils');

var _config = require('../config');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var SSEService = exports.SSEService = function () {
    function SSEService(connection) {
        _classCallCheck(this, SSEService);

        this.connection = connection;
        this._handlers = [];
    }

    _createClass(SSEService, [{
        key: '_initListeners',
        value: function _initListeners() {
            var _this = this;

            if (!this.jobListener) {
                this.jobListener = this.connection.subscribe('job', function (event) {
                    _this._handleJobEvent(event);
                }, { jenkins_org: _config.AppConfig.getOrganizationName() });
            }
        }

        /**
         * Add a handler for job events.
         *
         * @param {Function} handlerFn
         * @returns {string} id used by removeHandler
         */

    }, {
        key: 'registerHandler',
        value: function registerHandler(handlerFn) {
            var id = _utils.Utils.randomId('sse');

            this._handlers.push({
                id: id,
                handlerFn: handlerFn
            });

            return id;
        }

        /**
         * Remove a previously-registered handler.
         * @param id
         */

    }, {
        key: 'removeHandler',
        value: function removeHandler(id) {
            this._handlers = this._handlers.filter(function (handler) {
                return handler.id !== id;
            });
        }
    }, {
        key: '_handleJobEvent',
        value: function _handleJobEvent(event) {
            this._handlers.forEach(function (handler) {
                return handler.handlerFn(event);
            });
        }
    }]);

    return SSEService;
}();
//# sourceMappingURL=SSEService.js.map
