'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SseBus = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Created by cmeyers on 7/29/16.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _isomorphicFetch = require('isomorphic-fetch');

var _isomorphicFetch2 = _interopRequireDefault(_isomorphicFetch);

var _urlconfig = require('../urlconfig');

var _utils = require('../utils');

var _config = require('../config');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Wraps the SSE Gateway and fetches data related to events from REST API.
 */
var SseBus = exports.SseBus = function () {
    function SseBus(connection, fetch) {
        _classCallCheck(this, SseBus);

        this.id = this._random();
        this.connection = connection;
        this.fetch = fetch || _isomorphicFetch2.default;
        this.externalListeners = {};
        this.sseListeners = {};
    }

    _createClass(SseBus, [{
        key: 'dispose',
        value: function dispose() {
            var _this = this;

            Object.keys(this.sseListeners).forEach(function (token) {
                _this.unsubscribe(token);
            });

            this.externalListeners = {};
            this.sseListeners = {};
        }

        /**
         * Subscribe to job events.
         * @param callback func to invoke with job data
         * @param jobFilter func invoked for each job event, return false to suppress callback invocation
         * @returns {number} unsubscribe token
         */

    }, {
        key: 'subscribeToJob',
        value: function subscribeToJob(callback, jobFilter) {
            var _this2 = this;

            var id = this._random();

            this.externalListeners[id] = {
                listener: callback,
                filter: jobFilter
            };

            if (!this.sseListeners.job) {
                var sseListener = this.connection.subscribe('job', function (event) {
                    _this2._handleJobEvent(event);
                }, { jenkins_org: _config.AppConfig.getOrganizationName() });

                this.sseListeners.job = sseListener;
            }

            return id;
        }
    }, {
        key: 'unsubscribe',
        value: function unsubscribe(token) {
            delete this.externalListeners[token];

            if (Object.keys(this.externalListeners).length === 0) {
                this.connection.unsubscribe(this.sseListeners.job);
                delete this.sseListeners.job;
            }
        }
    }, {
        key: '_handleJobEvent',
        value: function _handleJobEvent(event) {
            var _this3 = this;

            var subscriptions = Object.keys(this.externalListeners).map(function (subId) {
                return _this3.externalListeners[subId];
            });

            var interestedListeners = subscriptions.filter(function (sub) {
                return sub.filter(event);
            }).map(function (sub) {
                return sub.listener;
            });

            // if no filters are interested in the event, bail
            if (interestedListeners.length === 0) {
                return;
            }

            switch (event.jenkins_event) {
                case 'job_crud_created':
                case 'job_crud_deleted':
                case 'job_crud_renamed':
                    this._refetchPipelines();
                    break;
                case 'job_run_queue_buildable':
                case 'job_run_queue_enter':
                    this._enqueueJob(event, interestedListeners);
                    break;
                case 'job_run_queue_left':
                case 'job_run_queue_blocked':
                    {
                        break;
                    }
                case 'job_run_paused':
                case 'job_run_unpaused':
                case 'job_run_started':
                    {
                        this._updateJob(event, interestedListeners);
                        break;
                    }
                case 'job_run_ended':
                    {
                        this._updateJob(event, interestedListeners);
                        break;
                    }
                default:
                // Else ignore the event.
            }
        }
    }, {
        key: '_refetchPipelines',
        value: function _refetchPipelines() {
            // TODO: implement once migration into commons JS
        }
    }, {
        key: '_enqueueJob',
        value: function _enqueueJob(event, listeners) {
            var queuedRun = {};

            queuedRun.pipeline = event.job_ismultibranch ? event.blueocean_job_branch_name : event.blueocean_job_pipeline_name;

            var runUrl = _utils.Utils.cleanSlashes(event.blueocean_job_rest_url + '/runs/' + event.job_run_queueId);

            queuedRun._links = {
                self: {
                    href: runUrl
                }
            };

            queuedRun.state = 'QUEUED';
            queuedRun.result = 'UNKNOWN';

            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = listeners[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var listener = _step.value;

                    listener(queuedRun, event);
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }
        }
    }, {
        key: '_updateJob',
        value: function _updateJob(event, listeners) {
            var baseUrl = _urlconfig.UrlConfig.getJenkinsRootURL();
            var url = _utils.Utils.cleanSlashes(baseUrl + '/' + event.blueocean_job_rest_url + '/runs/' + event.jenkins_object_id);

            this.fetch(url).then(function (data) {
                var updatedRun = _utils.Utils.clone(data);

                // FIXME: Talk to CMeyers why we cannot use the data.state?
                // in many cases the SSE and subsequent REST call occur so quickly
                // that the run's state is stale. force the state to the correct value.
                if (event.jenkins_event === 'job_run_ended') {
                    updatedRun.state = 'FINISHED';
                    // in some cases the state is finished but result is still unknown; assume success for now
                    if (updatedRun.result === 'UNKNOWN') {
                        console.log('forcing run result from UNKNOWN to SUCCESS for ' + url);
                        updatedRun.result = 'SUCCESS';
                    }
                } else if (event.jenkins_event === 'job_run_paused') {
                    updatedRun.state = 'PAUSED';
                } else {
                    updatedRun.state = 'RUNNING';
                }

                var _iteratorNormalCompletion2 = true;
                var _didIteratorError2 = false;
                var _iteratorError2 = undefined;

                try {
                    for (var _iterator2 = listeners[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                        var listener = _step2.value;

                        listener(updatedRun, event);
                    }
                } catch (err) {
                    _didIteratorError2 = true;
                    _iteratorError2 = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion2 && _iterator2.return) {
                            _iterator2.return();
                        }
                    } finally {
                        if (_didIteratorError2) {
                            throw _iteratorError2;
                        }
                    }
                }
            });
        }
    }, {
        key: '_updateMultiBranchPipelineBranches',
        value: function _updateMultiBranchPipelineBranches() {}
        // TODO: implement once migration into commons JS


        /**
         * @returns {number}
         * @private
         */

    }, {
        key: '_random',
        value: function _random() {
            return Math.random() * Math.pow(10, 16);
        }
    }]);

    return SseBus;
}();
//# sourceMappingURL=SseBus.js.map
