/*********************************************************************************************
 **********************************************************************************************

 General URL utility functions.

 For constructing specific URLs (such as ui links to screens, REST or classic links, etc), see
 the UrlBuilder module.

 **********************************************************************************************
 *********************************************************************************************/
/**
 * Double encode name, feature/test#1 is encoded as feature%252Ftest%25231
 *
 * Branch names are double-encoded in REST urls due to issues on the backend on certain filesystems.
 */
export declare function doubleUriEncode(input: string): string;
/**
 * Appended to the end of various URLs to signal you want all of a resource that is normally paged.
 */
export declare const fetchAllSuffix = "?start=0";
/**
 * Append a slash to the input url if it doesn't end with one already.
 */
export declare function ensureTrailingSlash(url: string): string;
export declare const UrlUtils: {
    doubleUriEncode: typeof doubleUriEncode;
    fetchAllSuffix: string;
    ensureTrailingSlash: typeof ensureTrailingSlash;
};
