/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.User;
import io.jenkins.blueocean.blueocean_git_pipeline.GitScm;
import io.jenkins.blueocean.blueocean_git_pipeline.GitUtils;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.credential.CredentialsUtils;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import io.jenkins.blueocean.ssh.UserSSHKeyManager;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.plugins.git.AbstractGitSCMSource;

abstract class GitReadSaveRequest {
    static final Logger log = Logger.getLogger(GitReadSaveRequest.class.getName());
    final AbstractGitSCMSource gitSource;
    final String branch;
    final String commitMessage;
    final String sourceBranch;
    final String filePath;
    final byte[] contents;

    GitReadSaveRequest(AbstractGitSCMSource gitSource, String branch, String commitMessage, String sourceBranch, String filePath, byte[] contents) {
        this.gitSource = gitSource;
        this.branch = branch;
        this.commitMessage = commitMessage;
        this.sourceBranch = sourceBranch;
        this.filePath = filePath;
        this.contents = contents == null ? null : (byte[])contents.clone();
    }

    @CheckForNull
    StandardCredentials getCredential() {
        BasicSSHUserPrivateKey credential = null;
        User user = User.current();
        if (user == null) {
            throw new ServiceException.UnauthorizedException("Not authenticated");
        }
        if (GitUtils.isSshUrl(this.gitSource.getRemote()) || GitUtils.isLocalUnixFileUrl(this.gitSource.getRemote())) {
            credential = UserSSHKeyManager.getOrCreate(user);
        } else {
            String credentialId = GitScm.makeCredentialId(this.gitSource.getRemote());
            if (credentialId != null) {
                credential = (StandardCredentials)CredentialsUtils.findCredential((String)credentialId, StandardCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
            }
        }
        return credential;
    }

    abstract byte[] read() throws IOException;

    abstract void save() throws IOException;
}

