/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.auth.jwt;

import io.jenkins.blueocean.auth.jwt.JwtSigningKeyProvider;
import io.jenkins.blueocean.auth.jwt.JwtTokenDecorator;
import io.jenkins.blueocean.auth.jwt.SigningKey;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.security.Key;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class JwtToken
implements HttpResponse {
    private static final Logger LOGGER = Logger.getLogger(JwtToken.class.getName());
    public static final String X_BLUEOCEAN_JWT = "X-BLUEOCEAN-JWT";
    public final JSONObject header = new JSONObject();
    public final JSONObject claim = new JSONObject();

    public String sign() {
        for (JwtTokenDecorator decorator : JwtTokenDecorator.all()) {
            decorator.decorate(this);
        }
        for (JwtSigningKeyProvider signer : JwtSigningKeyProvider.all()) {
            SigningKey k = signer.select(this);
            if (k == null) continue;
            try {
                JsonWebSignature jsonWebSignature = new JsonWebSignature();
                jsonWebSignature.setPayload(this.claim.toString());
                jsonWebSignature.setKey((Key)k.getKey());
                jsonWebSignature.setKeyIdHeaderValue(k.getKid());
                jsonWebSignature.setAlgorithmHeaderValue("RS256");
                jsonWebSignature.setHeader("typ", "JWT");
                return jsonWebSignature.getCompactSerialization();
            }
            catch (JoseException e) {
                String msg = "Failed to sign JWT token: " + e.getMessage();
                LOGGER.log(Level.SEVERE, "Failed to sign JWT token", e);
                throw new ServiceException.UnexpectedErrorException(msg, (Throwable)e);
            }
        }
        throw new IllegalStateException("No key is available to sign a token");
    }

    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        rsp.setStatus(204);
        rsp.addHeader(X_BLUEOCEAN_JWT, this.sign());
    }
}

