/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import hudson.Extension;
import io.jenkins.blueocean.rest.factory.BlueTrendFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineImpl;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineStep;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.rest.model.BlueTableRow;
import io.jenkins.blueocean.rest.model.BlueTrend;
import io.jenkins.blueocean.rest.model.Container;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

public class StageDurationTrend
extends BlueTrend {
    private final PipelineImpl pipeline;
    private final Link parent;

    public StageDurationTrend(PipelineImpl pipeline, Link parent) {
        this.pipeline = pipeline;
        this.parent = parent;
    }

    public String getId() {
        return "stageDuration";
    }

    public String getDisplayName() {
        return "Stage Duration";
    }

    public Map<String, String> getColumns() {
        return Collections.emptyMap();
    }

    public Link getLink() {
        return this.parent.rel(this.getId());
    }

    public Container<BlueTableRow> getRows() {
        final BlueRunContainer blueRunContainer = this.pipeline.getRuns();
        return new Container<BlueTableRow>(){

            public Link getLink() {
                return StageDurationTrend.this.parent.rel("rows");
            }

            public BlueTableRow get(String name) {
                return null;
            }

            public Iterator<BlueTableRow> iterator() {
                return blueRunContainer == null ? null : StreamSupport.stream(blueRunContainer.spliterator(), false).map(blueRun -> new StageDurationTrendRow((BlueRun)blueRun)).iterator();
            }
        };
    }

    @Extension
    public static class FactoryImpl
    extends BlueTrendFactory {
        public BlueTrend getTrend(BluePipeline pipeline, Link parent) {
            if (!(pipeline instanceof PipelineImpl)) {
                return null;
            }
            PipelineImpl pipelineImpl = (PipelineImpl)pipeline;
            return new StageDurationTrend(pipelineImpl, parent);
        }
    }

    @ExportedBean(defaultVisibility=1000)
    public static class StageDurationTrendRow
    extends BlueTableRow {
        static final String NODES = "nodes";
        private final BlueRun run;

        public StageDurationTrendRow(BlueRun run) {
            this.run = run;
        }

        public String getId() {
            return this.run.getId();
        }

        @Exported(name="nodes")
        public Map getNodes() {
            return StreamSupport.stream(this.run.getNodes().spliterator(), false).collect(Collectors.toMap(BluePipelineStep::getDisplayName, BluePipelineStep::getDurationInMillis));
        }
    }
}

