/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Item;
import org.kohsuke.stapler.StaplerRequest2;

public abstract class ScmContentProvider
implements ExtensionPoint {
    @NonNull
    public abstract String getScmId();

    @CheckForNull
    public abstract String getApiUrl(@NonNull Item var1);

    @CheckForNull
    public abstract Object getContent(@NonNull StaplerRequest2 var1, @NonNull Item var2);

    @CheckForNull
    public abstract Object saveContent(@NonNull StaplerRequest2 var1, @NonNull Item var2);

    public abstract boolean support(@NonNull Item var1);

    public static ScmContentProvider resolve(@NonNull Item item) {
        for (ScmContentProvider provider : ScmContentProvider.all()) {
            if (!provider.support(item)) continue;
            return provider;
        }
        return null;
    }

    public static ExtensionList<ScmContentProvider> all() {
        return ExtensionList.lookup(ScmContentProvider.class);
    }
}

