/*
 * Decompiled with CFR 0.152.
 */
package io.blueocean.rest.pipeline.editor;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.security.csrf.CrumbIssuer;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import io.blueocean.rest.pipeline.editor.ExportedBuildCondition;
import io.blueocean.rest.pipeline.editor.ExportedDescribableModel;
import io.blueocean.rest.pipeline.editor.ExportedDescribableParameterDecorator;
import io.blueocean.rest.pipeline.editor.ExportedPipelineFunction;
import io.blueocean.rest.pipeline.editor.ExportedPipelineStep;
import io.blueocean.rest.pipeline.editor.ExportedToolDescriptor;
import io.jenkins.blueocean.commons.stapler.TreeResponse;
import io.jenkins.blueocean.rest.ApiRoutable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgentDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.model.BuildCondition;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.BlockedStepsAndMethodCalls;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.kohsuke.stapler.NoStaplerConstructorException;
import org.kohsuke.stapler.verb.GET;

@Extension
public class PipelineMetadataService
implements ApiRoutable {
    static final List<String> INCLUDED_ADVANCED_STEPS = Collections.unmodifiableList(Arrays.asList("catchError", "container"));

    public String getUrlName() {
        return "pipeline-metadata";
    }

    @GET
    public String doCrumbInfo() {
        CrumbIssuer crumbIssuer = Jenkins.get().getCrumbIssuer();
        if (crumbIssuer != null) {
            return crumbIssuer.getCrumbRequestField() + "=" + crumbIssuer.getCrumb();
        }
        return "";
    }

    @GET
    @TreeResponse
    public ExportedDescribableModel[] doAgentMetadata() {
        ArrayList<ExportedDescribableModel> models = new ArrayList<ExportedDescribableModel>();
        for (DeclarativeAgentDescriptor d : DeclarativeAgentDescriptor.all()) {
            try {
                DescribableModel model = new DescribableModel(d.clazz);
                String symbol = this.symbolForObject(d);
                if ("label".equals(symbol)) {
                    symbol = "node";
                }
                models.add(new ExportedDescribableModel(model, symbol));
            }
            catch (NoStaplerConstructorException noStaplerConstructorException) {}
        }
        return models.toArray(new ExportedDescribableModel[0]);
    }

    @GET
    @TreeResponse
    public ExportedToolDescriptor[] doToolMetadata() {
        ArrayList<ExportedToolDescriptor> models = new ArrayList<ExportedToolDescriptor>();
        for (ToolDescriptor d : ToolInstallation.all()) {
            ExportedToolDescriptor descriptor = new ExportedToolDescriptor(d.getDisplayName(), this.symbolForObject(d), d.getClass());
            models.add(descriptor);
            for (ToolInstallation installation : d.getInstallations()) {
                descriptor.addInstallation(new ExportedToolDescriptor.ExportedToolInstallation(installation.getName(), installation.getClass()));
            }
        }
        return models.toArray(new ExportedToolDescriptor[0]);
    }

    @GET
    @TreeResponse
    public ExportedBuildCondition[] doBuildConditions() {
        List<ExportedBuildCondition> exported = BuildCondition.all().stream().map(c -> new ExportedBuildCondition(this.symbolForObject(c), c.getDescription())).collect(Collectors.toList());
        exported.sort(Comparator.comparing(ExportedBuildCondition::getName));
        return exported.toArray(new ExportedBuildCondition[0]);
    }

    @GET
    @TreeResponse
    public ExportedPipelineStep[] doWrapperMetadata() {
        ArrayList<ExportedPipelineStep> wrappers = new ArrayList<ExportedPipelineStep>();
        for (StepDescriptor d : StepDescriptor.all()) {
            ExportedPipelineStep step;
            if (!this.isWrapper(d) || (step = this.getStepMetadata(d)) == null) continue;
            wrappers.add(step);
        }
        return wrappers.toArray(new ExportedPipelineStep[wrappers.size()]);
    }

    @GET
    @TreeResponse
    public ExportedPipelineFunction[] doPipelineStepMetadata() {
        ArrayList<ExportedPipelineFunction> pd = new ArrayList<ExportedPipelineFunction>();
        for (StepDescriptor d : StepDescriptor.all()) {
            ExportedPipelineStep exportedPipelineStep;
            if (!this.includeStep(d) || (exportedPipelineStep = this.getStepMetadata(d)) == null) continue;
            pd.add(exportedPipelineStep);
        }
        ArrayList metaStepDescriptors = new ArrayList();
        this.populateMetaSteps(metaStepDescriptors, Builder.class);
        this.populateMetaSteps(metaStepDescriptors, Publisher.class);
        this.populateMetaSteps(metaStepDescriptors, BuildWrapper.class);
        for (Descriptor descriptor : metaStepDescriptors) {
            ExportedPipelineFunction metaStep = this.getStepMetadata(descriptor);
            if (metaStep == null) continue;
            pd.add(metaStep);
        }
        return pd.toArray(new ExportedPipelineFunction[pd.size()]);
    }

    private boolean isWrapper(StepDescriptor d) {
        return this.includeStep(d) && d.takesImplicitBlockArgument() && !d.getRequiredContext().contains(FilePath.class) && !d.getRequiredContext().contains(Launcher.class);
    }

    private boolean includeStep(StepDescriptor d) {
        boolean include = true;
        if (BlockedStepsAndMethodCalls.blockedInSteps().containsKey(d.getFunctionName())) {
            include = false;
        } else if (d.isAdvanced() && !INCLUDED_ADVANCED_STEPS.contains(d.getFunctionName())) {
            include = false;
        }
        return include;
    }

    private <T extends Describable<T>, D extends Descriptor<T>> void populateMetaSteps(List<Descriptor<?>> r, Class<T> c) {
        Jenkins j = Jenkins.get();
        for (Descriptor d : j.getDescriptorList(c)) {
            if (SimpleBuildStep.class.isAssignableFrom(d.clazz) && this.symbolForObject(d) != null) {
                r.add(d);
                continue;
            }
            if (!SimpleBuildWrapper.class.isAssignableFrom(d.clazz) || this.symbolForObject(d) == null) continue;
            r.add(d);
        }
    }

    @CheckForNull
    private String symbolForObject(Object d) {
        Set symbols = SymbolLookup.getSymbolValue((Object)d);
        if (!symbols.isEmpty()) {
            return (String)symbols.iterator().next();
        }
        return null;
    }

    @CheckForNull
    private ExportedPipelineFunction getStepMetadata(Descriptor<?> d) {
        String symbol = this.symbolForObject(d);
        if (symbol != null) {
            ExportedPipelineFunction f = new ExportedPipelineFunction(new DescribableModel(d.clazz), symbol);
            for (ExportedDescribableParameterDecorator decorator : ExtensionList.lookup(ExportedDescribableParameterDecorator.class)) {
                decorator.decorate(f, f.getParameters());
            }
            return f;
        }
        return null;
    }

    @CheckForNull
    private ExportedPipelineStep getStepMetadata(StepDescriptor d) {
        try {
            DescribableModel model = new DescribableModel(d.clazz);
            ExportedPipelineStep step = new ExportedPipelineStep((DescribableModel<? extends Step>)model, d.getFunctionName(), d);
            for (ExportedDescribableParameterDecorator decorator : ExtensionList.lookup(ExportedDescribableParameterDecorator.class)) {
                decorator.decorate(step, step.getParameters());
            }
            return step;
        }
        catch (NoStaplerConstructorException e) {
            return null;
        }
    }
}

