/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded;

import hudson.Extension;
import hudson.model.ItemGroup;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.service.embedded.rest.OrganizationImpl;
import java.util.Collection;
import java.util.Collections;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.apache.commons.lang.StringUtils;

@Extension(ordinal=-100.0)
public class OrganizationFactoryImpl
extends OrganizationFactory {
    private static final String ORGANIZATION_NAME = StringUtils.defaultIfBlank((String)System.getProperty("BLUE_ORGANIZATION_NAME"), (String)"jenkins");
    private final OrganizationImpl instance;

    public OrganizationFactoryImpl() {
        this(ORGANIZATION_NAME);
    }

    public OrganizationFactoryImpl(String name) {
        this.instance = new OrganizationImpl(name, (ModifiableTopLevelItemGroup)Jenkins.get());
    }

    public BlueOrganization get(String name) {
        if (this.instance.getName().equals(name)) {
            return this.instance;
        }
        return null;
    }

    public Collection<BlueOrganization> list() {
        return Collections.singletonList(this.instance);
    }

    public OrganizationImpl of(ItemGroup group) {
        return group == this.instance.getGroup() ? this.instance : null;
    }
}

