/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.factory;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Job;
import hudson.scm.ChangeLogSet;
import io.jenkins.blueocean.rest.model.BlueIssue;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlueIssueFactory
implements ExtensionPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BlueIssueFactory.class.getName());

    public abstract Collection<BlueIssue> getIssues(Job var1);

    public abstract Collection<BlueIssue> getIssues(ChangeLogSet.Entry var1);

    public static Collection<BlueIssue> resolve(Job job) {
        LinkedHashSet<BlueIssue> allIssues = new LinkedHashSet<BlueIssue>();
        for (BlueIssueFactory factory : ExtensionList.lookup(BlueIssueFactory.class)) {
            try {
                Collection<BlueIssue> issues = factory.getIssues(job);
                if (issues == null) continue;
                allIssues.addAll(issues);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to fetch issues for job " + e.getMessage(), (Throwable)e);
            }
        }
        return allIssues;
    }

    public static Collection<BlueIssue> resolve(ChangeLogSet.Entry changeSetEntry) {
        LinkedHashSet<BlueIssue> allIssues = new LinkedHashSet<BlueIssue>();
        for (BlueIssueFactory factory : ExtensionList.lookup(BlueIssueFactory.class)) {
            try {
                Collection<BlueIssue> issues = factory.getIssues(changeSetEntry);
                if (issues == null) continue;
                allIssues.addAll(issues);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to fetch issues for changeSetEntry " + e.getMessage(), (Throwable)e);
            }
        }
        return allIssues;
    }
}

