/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean;

import hudson.ExtensionList;
import hudson.Main;
import hudson.security.csrf.CrumbIssuer;
import io.jenkins.blueocean.BlueOceanUIProvider;
import io.jenkins.blueocean.BluePageDecorator;
import io.jenkins.blueocean.ResourceCacheControl;
import io.jenkins.blueocean.RootRoutable;
import io.jenkins.blueocean.dev.RunBundleWatches;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueOceanUI {
    private static final Logger logger = LoggerFactory.getLogger(BlueOceanUI.class);
    private volatile BlueOceanUIProvider provider;

    public BlueOceanUI() {
        ResourceCacheControl.install();
    }

    public Object getDynamic(String route) {
        if (RunBundleWatches.isEnabled) {
            RunBundleWatches.waitForScriptBuilds();
        }
        for (RootRoutable r : ExtensionList.lookup(RootRoutable.class)) {
            if (!r.getUrlName().equals(route)) continue;
            return r;
        }
        return this;
    }

    public String getUrlBase() {
        this.setBlueOceanUIProvider();
        if (this.provider == null) {
            logger.error("BlueOceanUIProvider extension not found");
            return null;
        }
        return this.provider.getUrlBasePrefix();
    }

    public boolean isDevelopmentMode() {
        return Main.isDevelopmentMode || System.getProperty("hudson.hpi.run") != null;
    }

    public String getLang() {
        Locale locale;
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        if (currentRequest != null && (locale = currentRequest.getLocale()) != null) {
            return locale.toLanguageTag();
        }
        return null;
    }

    public String getCrumbToken() {
        CrumbIssuer crumbIssuer = Jenkins.get().getCrumbIssuer();
        return crumbIssuer == null ? "" : crumbIssuer.getCrumb();
    }

    public String getCrumbRequestField() {
        CrumbIssuer crumbIssuer = Jenkins.get().getCrumbIssuer();
        return crumbIssuer == null ? "" : crumbIssuer.getCrumbRequestField();
    }

    public List<BluePageDecorator> getPageDecorators() {
        return BluePageDecorator.all();
    }

    public long getNow() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBlueOceanUIProvider() {
        BlueOceanUIProvider boui = this.provider;
        if (boui == null) {
            BlueOceanUI blueOceanUI = this;
            synchronized (blueOceanUI) {
                Iterator iterator;
                boui = this.provider;
                if (boui == null && (iterator = BlueOceanUIProvider.all().iterator()).hasNext()) {
                    BlueOceanUIProvider p;
                    this.provider = boui = (p = (BlueOceanUIProvider)iterator.next());
                    return;
                }
            }
        }
    }
}

