/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.dev;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecursivePathWatcher {
    private static final PathFilter ALLOW_ALL_PATHS = new PathFilter(){

        @Override
        public boolean allows(Path path) {
            return true;
        }
    };
    private static WatchEvent.Modifier HIGH_SENSITIVITY = RecursivePathWatcher.get_com_sun_nio_file_SensitivityWatchEventModifier_HIGH();
    private static WatchEvent.Kind[] EVENT_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    private static Logger log = Logger.getLogger(RecursivePathWatcher.class.getName());
    private final Path root;
    private final PathFilter pathFilter;
    private volatile WatchService watchService;
    private boolean running;
    private final Map<WatchKey, Path> keys = new ConcurrentHashMap<WatchKey, Path>();
    private final Map<Path, WatchKey> dirs = new ConcurrentHashMap<Path, WatchKey>();

    private static WatchEvent.Modifier get_com_sun_nio_file_SensitivityWatchEventModifier_HIGH() {
        try {
            Class<?> c = Class.forName("com.sun.nio.file.SensitivityWatchEventModifier");
            Field f = c.getField("HIGH");
            return (WatchEvent.Modifier)f.get(c);
        }
        catch (Exception e) {
            return null;
        }
    }

    public RecursivePathWatcher(Path root) {
        this(root, ALLOW_ALL_PATHS);
    }

    public RecursivePathWatcher(Path root, PathFilter pathFilter) {
        this.root = root;
        this.pathFilter = pathFilter;
        this.initWatchService();
    }

    private void initWatchService() {
        try {
            this.keys.clear();
            this.watchService = this.root.getFileSystem().newWatchService();
            this.register(this.root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void register(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attributes) throws IOException {
                if (RecursivePathWatcher.this.root.equals(dir) || RecursivePathWatcher.this.pathFilter.allows(RecursivePathWatcher.this.root.relativize(dir))) {
                    WatchKey key = dir.register(RecursivePathWatcher.this.watchService, EVENT_KINDS, HIGH_SENSITIVITY);
                    RecursivePathWatcher.this.keys.put(key, dir);
                    RecursivePathWatcher.this.dirs.put(dir, key);
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
    }

    public void start(PathEventHandler eventHandler) {
        this.running = true;
        while (this.running) {
            try {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Ready... watching: " + String.valueOf(this.dirs.keySet()));
                }
                WatchKey watchKey = this.watchService.take();
                Path dir = this.keys.get(watchKey);
                for (WatchEvent<?> event : watchKey.pollEvents()) {
                    Object entry = event.context();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(String.valueOf(event.kind()) + ": " + String.valueOf(entry));
                    }
                    if (!(entry instanceof Path)) continue;
                    Path name = (Path)entry;
                    Path child = dir.resolve(name);
                    if (this.dirs.containsKey(child)) {
                        if (!StandardWatchEventKinds.ENTRY_DELETE.equals(event.kind())) continue;
                        Iterator<Map.Entry<Path, WatchKey>> i = this.dirs.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry<Path, WatchKey> d = i.next();
                            if (!d.getKey().startsWith(child)) continue;
                            i.remove();
                            d.getValue().cancel();
                            this.keys.remove(d.getValue());
                        }
                        continue;
                    }
                    if (Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                        if (!StandardWatchEventKinds.ENTRY_CREATE.equals(event.kind())) continue;
                        this.register(child);
                        continue;
                    }
                    if (StandardWatchEventKinds.ENTRY_CREATE.equals(event.kind())) {
                        eventHandler.accept(Event.CREATE, child);
                        continue;
                    }
                    if (StandardWatchEventKinds.ENTRY_DELETE.equals(event.kind())) {
                        eventHandler.accept(Event.DELETE, child);
                        continue;
                    }
                    if (!StandardWatchEventKinds.ENTRY_MODIFY.equals(event.kind())) continue;
                    eventHandler.accept(Event.MODIFY, child);
                }
                if (watchKey.reset()) continue;
                watchKey.cancel();
                if (!this.root.equals(dir)) continue;
                this.watchService.close();
                this.initWatchService();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void terminate() {
        this.running = false;
        try {
            this.watchService.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static interface PathFilter {
        public boolean allows(Path var1);
    }

    public static enum Event {
        CREATE,
        DELETE,
        MODIFY;

    }

    public static interface PathEventHandler {
        public void accept(Event var1, Path var2);
    }
}

