'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FloatingElement = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

//--------------------------------------------------------------------------
//
//  Constants / types
//
//--------------------------------------------------------------------------

var pollingInterval = 50; // ms
var fixedAnimationDuration = 500; // ms

var stateInit = 'init'; // Created, not yet correctly positioned
var stateStable = 'stable'; // Correctly positioned, all good
var stateMoving = 'moving'; // Moving to new correct position

var lifecycleStates = {
    init: 'init',
    stable: 'stable',
    moving: 'moving'
};

//--------------------------------------------------------------------------
//
//  Helpers
//
//--------------------------------------------------------------------------

//--------------------------------------
//  Animation easing
//--------------------------------------

// t: current time, b: beginning value, c: change In value, d: duration
// Based on https://github.com/danro/jquery-easing/

var tween = easeInOutCubic;

function easeInOutCubic(t, b, c, d) {
    if ((t /= d / 2) < 1) return c / 2 * t * t * t + b;
    return c / 2 * ((t -= 2) * t * t + 2) + b;
}

//--------------------------------------------------------------------------
//
//  Main Component
//
//--------------------------------------------------------------------------

var FloatingElement = exports.FloatingElement = function (_Component) {
    _inherits(FloatingElement, _Component);

    function FloatingElement() {
        var _ref;

        var _temp, _this, _ret;

        _classCallCheck(this, FloatingElement);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = FloatingElement.__proto__ || Object.getPrototypeOf(FloatingElement)).call.apply(_ref, [this].concat(args))), _this), _this.lifecycleState = stateInit, _this.currentLeft = 0, _this.currentTop = 0, _this.animationStart = 0, _this.animationDuration = 0, _this.goalLeft = 0, _this.goalTop = 0, _this.selfWidth = 0, _this.selfHeight = 0, _this.targetWidth = 0, _this.targetHeight = 0, _this.targetLeft = 0, _this.targetTop = 0, _this.viewportWidth = 0, _this.viewportHeight = 0, _this.positioningValid = false, _this.validatePositioningScheduled = false, _this.checkDOMDependenciesScheduled = false, _this.pollingTimeout = null, _this.movePopoverAnimationFrame = function (now) {
            var node = _this.refs.wrapper;
            var _this2 = _this,
                lifecycleState = _this2.lifecycleState,
                currentLeft = _this2.currentLeft,
                currentTop = _this2.currentTop,
                animationStart = _this2.animationStart,
                animationDuration = _this2.animationDuration,
                goalLeft = _this2.goalLeft,
                goalTop = _this2.goalTop;


            if (!node || lifecycleState !== stateMoving) {
                return; // Nothing to do here
            }

            // If we're done, make sure to set correct location, stop animation
            if (now >= animationStart + animationDuration) {
                _this.currentLeft = goalLeft;
                _this.currentTop = goalTop;
                _this.animationStart = 0;
                _this.animationDuration = 0;
                _this.goalLeft = 0;
                _this.goalTop = 0;
                _this.lifecycleState = stateStable;

                node.style.left = goalLeft + 'px';
                node.style.top = goalTop + 'px';

                return;
            }

            var newLeft = 0,
                newTop = 0;
            var time = now - animationStart;

            newLeft = Math.round(tween(time, currentLeft, goalLeft - currentLeft, animationDuration));

            newTop = Math.round(tween(time, currentTop, goalTop - currentTop, animationDuration));

            // Position the node, update state
            node.style.left = newLeft + 'px';
            node.style.top = newTop + 'px';

            // Request another frame
            window.requestAnimationFrame(_this.movePopoverAnimationFrame);
        }, _temp), _possibleConstructorReturn(_this, _ret);
    }
    //--------------------------------------
    //  Internal State
    //--------------------------------------

    //--------------------------------------
    //  Animation Progress
    //--------------------------------------

    // ms
    // ms
    // Goal-point for animation
    // Goal-point for animation

    //--------------------------------------
    //  Last-known measurements
    //--------------------------------------

    //--------------------------------------
    //  Positioning Loop
    //--------------------------------------

    _createClass(FloatingElement, [{
        key: 'checkDOMDependencies',


        /**
         Checks the measurements of things we depend on, and invalidate positioning
         if they've changed. This is designed to be called often, from a timer or
         event listeners.
          Can be called at any time, and will schedule itself into an animation
         frame.
         */
        value: function checkDOMDependencies() {
            var _this3 = this;

            if (this.positioningValid && !this.validatePositioningScheduled && !this.checkDOMDependenciesScheduled) {
                this.checkDOMDependenciesScheduled = true;
                window.requestAnimationFrame(function () {
                    _this3.checkDOMDependenciesScheduled = false;
                    if (_this3.measureDOMNodes()) {
                        _this3.invalidatePositioning();
                    }
                });
            }
        }

        /**
         Call when you want to make sure to re-calculate the positioning.
          Can be called at any time, and will schedule itself into an animation
         frame.
         */

    }, {
        key: 'invalidatePositioning',
        value: function invalidatePositioning() {
            var _this4 = this;

            if (this.positioningValid) {
                this.positioningValid = false;
            }

            if (!this.validatePositioningScheduled) {
                this.validatePositioningScheduled = true;

                window.requestAnimationFrame(function () {
                    _this4.validatePositioningScheduled = false;
                    _this4.validatePositioning();
                });
            }
        }

        /**
         Check for invalidated positioning, and re-calculate / move if necessary
          Should only be called via window.requestAnimationFrame().
         */

    }, {
        key: 'validatePositioning',
        value: function validatePositioning() {
            if (!this.positioningValid) {
                this.calculateAndSetPopupPosition();
            }
        }

        /**
         Locate and measure the DOM nodes of target and self.
         Returns true if there's a change.
          Should only be called via window.requestAnimationFrame().
         */

    }, {
        key: 'measureDOMNodes',
        value: function measureDOMNodes() {
            var newSelfWidth = 0;
            var newSelfHeight = 0;

            var newTargetWidth = 0;
            var newTargetHeight = 0;
            var newTargetLeft = 0;
            var newTargetTop = 0;

            var newViewportWidth = 0;
            var newViewportHeight = 0;

            // Measure self
            var selfNode = this.refs.wrapper;
            if (selfNode) {
                newSelfWidth = selfNode.offsetWidth;
                newSelfHeight = selfNode.offsetHeight;
            }

            // Measure and locate target element
            var targetNode = this.props.targetElement;

            if (targetNode) {
                newTargetWidth = targetNode.offsetWidth;
                newTargetHeight = targetNode.offsetHeight;

                // Calculate total position (only offsetParent chain)
                var node = targetNode;
                while (node) {
                    newTargetLeft += node.offsetLeft;
                    newTargetTop += node.offsetTop;

                    node = node.offsetParent;
                }

                // Calculate total scroll offset (can be in any ancestor)
                node = targetNode.parentElement;
                while (node) {
                    if (node.scrollLeft) {
                        newTargetLeft -= node.scrollLeft;
                    }
                    if (node.scrollTop) {
                        newTargetTop -= node.scrollTop;
                    }

                    node = node.parentElement;
                }
            }

            // Viewport
            newViewportWidth = window.innerWidth;
            newViewportHeight = window.innerHeight;

            var changed = newSelfWidth !== this.selfWidth || newSelfHeight !== this.selfHeight || newTargetWidth !== this.targetWidth || newTargetHeight !== this.targetHeight || newTargetLeft !== this.targetLeft || newTargetTop !== this.targetTop || newViewportWidth !== this.viewportWidth || newViewportHeight !== this.viewportHeight;

            if (changed) {
                this.selfWidth = newSelfWidth;
                this.selfHeight = newSelfHeight;
                this.targetWidth = newTargetWidth;
                this.targetHeight = newTargetHeight;
                this.targetLeft = newTargetLeft;
                this.targetTop = newTargetTop;
                this.viewportWidth = newViewportWidth;
                this.viewportHeight = newViewportHeight;
            }

            return changed;
        }

        /**
         * Set the popover's initial position (off-screen)
         * Avoids a Safari/IE bug where content would flash at 0/0 before being positioned.
         */

    }, {
        key: 'setInitialPosition',
        value: function setInitialPosition() {
            this.movePopover(-9999, -9999);
            // leave in the init state so the eventual repositioning will happen immediately (no anim)
            this.lifecycleState = lifecycleStates.init;
        }

        /**
         Calculate popover position based on its dimensions, preferred position,
         and the dimensions and position of the anchor. If there's a change,
         invokes movePopover to move the popover.
          Should only be called via window.requestAnimationFrame().
         */

    }, {
        key: 'calculateAndSetPopupPosition',
        value: function calculateAndSetPopupPosition() {
            this.measureDOMNodes();

            var selfWidth = this.selfWidth,
                selfHeight = this.selfHeight,
                targetWidth = this.targetWidth,
                targetHeight = this.targetHeight,
                targetLeft = this.targetLeft,
                targetTop = this.targetTop,
                viewportWidth = this.viewportWidth,
                viewportHeight = this.viewportHeight;


            var newPositions = this.props.positionFunction(selfWidth, selfHeight, targetWidth, targetHeight, targetLeft, targetTop, viewportWidth, viewportHeight);

            var newLeft = newPositions.newLeft,
                newTop = newPositions.newTop;


            this.movePopover(newLeft, newTop);
            this.positioningValid = true;
        }

        /**
         Move the popover div to its new location. May begin an animation
         depending on current state
         */

    }, {
        key: 'movePopover',
        value: function movePopover(newLeft, newTop) {
            var node = this.refs.wrapper;

            if (!node) {
                return;
            }

            switch (this.lifecycleState) {
                case stateInit:
                    // Wishlist: Add an initial "appear" animation?
                    this.lifecycleState = stateStable;
                    this.currentLeft = newLeft;
                    this.currentTop = newTop;
                    node.style.left = this.currentLeft + 'px';
                    node.style.top = this.currentTop + 'px';
                    break;

                case stateStable:
                    this.lifecycleState = stateMoving;
                    this.animationStart = performance.now();
                    this.animationDuration = fixedAnimationDuration;
                    this.goalLeft = newLeft;
                    this.goalTop = newTop;
                    requestAnimationFrame(this.movePopoverAnimationFrame);
                    break;
                case stateMoving:
                    // Wishlist: try to merge old and new animations if moving by
                    // calculating a new virtual start position?
                    this.goalLeft = newLeft;
                    this.goalTop = newTop;
                    requestAnimationFrame(this.movePopoverAnimationFrame);
                    break;
            }
        }

        /**
         Schedule a future check of DOM sizes and positions to see if we need to
         move our popover. Will reschedule itself afterwards.
         */

    }, {
        key: 'startPollTimeout',
        value: function startPollTimeout() {
            var _this5 = this;

            if (this.pollingTimeout) {
                clearTimeout(this.pollingTimeout);
            }

            this.pollingTimeout = setTimeout(function () {
                _this5.pollingTimeout = null;
                _this5.checkDOMDependencies();
                _this5.startPollTimeout();
            }, pollingInterval);
        }

        //--------------------------------------
        //  Animation
        //--------------------------------------

        /**
         Renders a frame in the process of animating from currentLeft / currentTop
         to goalLeft / goalTop
         */

    }, {
        key: 'render',


        //--------------------------------------
        //  React Lifecycle
        //--------------------------------------

        value: function render() {
            var _props = this.props,
                children = _props.children,
                style = _props.style;

            var wrapperStyle = _extends({}, style, {
                left: this.currentLeft + 'px',
                top: this.currentTop + 'px'
            });
            return _react2.default.createElement(
                'div',
                { className: 'FloatingElement' },
                _react2.default.createElement(
                    'div',
                    { ref: 'wrapper', className: 'FloatingElement-wrapper', style: wrapperStyle },
                    children
                )
            );
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            if (nextProps.positionFunction !== this.props.positionFunction || nextProps.targetElement !== this.props.targetElement) {
                this.invalidatePositioning();
            }
        }
    }, {
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.componentRendered();
        }
    }, {
        key: 'componentDidUpdate',
        value: function componentDidUpdate() {
            this.componentRendered();
        }
    }, {
        key: 'componentRendered',
        value: function componentRendered() {
            var _this6 = this;

            this.setInitialPosition();
            // As soon as possible, we need to re-calculate our position
            this.validatePositioningScheduled = true;
            window.requestAnimationFrame(function () {
                _this6.validatePositioningScheduled = false;
                _this6.validatePositioning();
            });

            // Start the periodic timeout to check dom measurements
            this.startPollTimeout();
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            if (this.pollingTimeout) {
                clearTimeout(this.pollingTimeout);
                this.pollingTimeout = null;
            }
        }
    }]);

    return FloatingElement;
}(_react.Component);

FloatingElement.propTypes = {
    targetElement: _react.PropTypes.object,
    positionFunction: _react.PropTypes.func,
    style: _react.PropTypes.object,
    children: _react.PropTypes.node
};
//# sourceMappingURL=FloatingElement.js.map
