'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Toast = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Icon = require('./Icon');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Toast displays a small confirmation message with an optional action link and dismiss link.
 * Toast will auto-dismiss itself after 5s.
 *
 * Supported props:
 * text - Confirmation message text, e.g. "Run Started"
 * action - Optional action link, e.g. "Open"
 * onActionClick - function to invoke when action link is clicked
 * onDismiss - function to invoke when dismiss link is clicked, or Toast auto-dismisses.
 */
var Toast = exports.Toast = function (_Component) {
    _inherits(Toast, _Component);

    function Toast() {
        _classCallCheck(this, Toast);

        return _possibleConstructorReturn(this, (Toast.__proto__ || Object.getPrototypeOf(Toast)).apply(this, arguments));
    }

    _createClass(Toast, [{
        key: 'onActionClick',
        value: function onActionClick() {
            if (this.props.onActionClick) {
                this.props.onActionClick();
            }
        }
    }, {
        key: 'onDismissClick',
        value: function onDismissClick() {
            if (this.props.onDismiss) {
                this.props.onDismiss();
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            var toastStyle = this.props.style || 'default';
            return _react2.default.createElement(
                'div',
                { className: 'toast ' + toastStyle },
                _react2.default.createElement(
                    'span',
                    { className: 'text' },
                    _react2.default.createElement(Caption, { text: this.props.caption }),
                    this.props.text
                ),
                _react2.default.createElement(
                    'a',
                    { className: 'action', onClick: function onClick() {
                            return _this2.onActionClick();
                        } },
                    this.props.action
                ),
                _react2.default.createElement(
                    'a',
                    { className: 'dismiss', onClick: function onClick() {
                            return _this2.onDismissClick();
                        } },
                    _react2.default.createElement(_Icon.Icon, {
                        size: 18,
                        icon: 'ContentClear',
                        style: { fill: '#fff' }
                    })
                )
            );
        }
    }]);

    return Toast;
}(_react.Component);

Toast.propTypes = {
    caption: _react.PropTypes.string,
    text: _react.PropTypes.string,
    style: _react.PropTypes.string,
    action: _react.PropTypes.string,
    onActionClick: _react.PropTypes.func,
    onDismiss: _react.PropTypes.func
};

var Caption = function Caption(_ref) {
    var text = _ref.text;

    if (!text) {
        return null;
    }
    return _react2.default.createElement(
        'h4',
        { className: 'caption' },
        text
    );
};
Caption.propTypes = {
    text: _react.PropTypes.string
};
//# sourceMappingURL=Toast.js.map
