'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Dialog = exports.DialogButtonBar = exports.DialogContent = exports.DialogHeader = exports.BasicDialog = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _ModalContainer = require('./ModalContainer');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

//--------------------------------------------------------------------------
//
//  Basic Dialog
//
//--------------------------------------------------------------------------

/**
 Basic, bare-bones Dialog component:

 - Show the user a styled dialog, with any child content to be set by owner.
 - Listen for and re-dispatch user dismiss requests.

 */
var BasicDialog = exports.BasicDialog = function (_Component) {
    _inherits(BasicDialog, _Component);

    function BasicDialog() {
        var _ref;

        var _temp, _this, _ret;

        _classCallCheck(this, BasicDialog);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = BasicDialog.__proto__ || Object.getPrototypeOf(BasicDialog)).call.apply(_ref, [this].concat(args))), _this), _this.modalScreenClicked = function () {
            var onDismiss = _this.props.onDismiss;


            if (onDismiss) {
                onDismiss();
            }
        }, _this.keyPressed = function (event) {
            // TODO: Move this into ModalContainer, and remove from Popover as well!
            var _this$props = _this.props,
                onDismiss = _this$props.onDismiss,
                ignoreEscapeKey = _this$props.ignoreEscapeKey;


            if (!ignoreEscapeKey && onDismiss && event.keyCode === 27) {
                onDismiss();
            }
        }, _temp), _possibleConstructorReturn(_this, _ret);
    }

    //--------------------------------------
    //  User Interaction
    //--------------------------------------

    _createClass(BasicDialog, [{
        key: 'render',


        //--------------------------------------
        //  React Lifecycle
        //--------------------------------------

        value: function render() {
            var _props = this.props,
                className = _props.className,
                children = _props.children;

            var newClassName = (className ? className + ' ' : '') + ' Dialog';

            return _react2.default.createElement(
                _ModalContainer.ModalContainer,
                { onScreenClick: this.modalScreenClicked },
                _react2.default.createElement(
                    'div',
                    { className: newClassName },
                    children
                )
            );
        }
    }, {
        key: 'componentDidMount',
        value: function componentDidMount() {
            document.addEventListener('keyup', this.keyPressed, false);
            // TODO: Remove from here and Popover
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            document.removeEventListener('keyup', this.keyPressed, false);
            // TODO: Remove from here and Popover
        }
    }]);

    return BasicDialog;
}(_react.Component);

BasicDialog.propTypes = {
    onDismiss: _react.PropTypes.func,
    ignoreEscapeKey: _react.PropTypes.bool,
    children: _react.PropTypes.node
};

//--------------------------------------------------------------------------
//
//  Dialog Header / Title Bar
//
//--------------------------------------------------------------------------

/** Basic header for dialogs */

var DialogHeader = exports.DialogHeader = function (_Component2) {
    _inherits(DialogHeader, _Component2);

    function DialogHeader() {
        _classCallCheck(this, DialogHeader);

        return _possibleConstructorReturn(this, (DialogHeader.__proto__ || Object.getPrototypeOf(DialogHeader)).apply(this, arguments));
    }

    _createClass(DialogHeader, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                'div',
                { className: 'Dialog-header' },
                _react2.default.createElement(
                    'h3',
                    null,
                    this.props.children
                )
            );
        }
    }]);

    return DialogHeader;
}(_react.Component);

DialogHeader.propTypes = {
    children: _react.PropTypes.node
};

//--------------------------------------------------------------------------
//
//  Scrolling Content Pane
//
//--------------------------------------------------------------------------

/** Wraps the content of a dialog to provide a scrollbar if there's too much to fit */

var DialogContent = exports.DialogContent = function (_Component3) {
    _inherits(DialogContent, _Component3);

    function DialogContent() {
        _classCallCheck(this, DialogContent);

        return _possibleConstructorReturn(this, (DialogContent.__proto__ || Object.getPrototypeOf(DialogContent)).apply(this, arguments));
    }

    _createClass(DialogContent, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                'div',
                { className: 'Dialog-content-scroll' },
                _react2.default.createElement(
                    'div',
                    { className: 'Dialog-content-margin' },
                    this.props.children
                )
            );
        }
    }]);

    return DialogContent;
}(_react.Component);

DialogContent.propTypes = {
    children: _react.PropTypes.node
};

//--------------------------------------------------------------------------
//
//  Button bar
//
//--------------------------------------------------------------------------

/** A container for dialog action buttons */

var DialogButtonBar = exports.DialogButtonBar = function (_Component4) {
    _inherits(DialogButtonBar, _Component4);

    function DialogButtonBar() {
        _classCallCheck(this, DialogButtonBar);

        return _possibleConstructorReturn(this, (DialogButtonBar.__proto__ || Object.getPrototypeOf(DialogButtonBar)).apply(this, arguments));
    }

    _createClass(DialogButtonBar, [{
        key: 'render',
        value: function render() {
            var children = this.props.children;


            return _react2.default.createElement(
                'div',
                { className: 'Dialog-button-bar' },
                children
            );
        }
    }]);

    return DialogButtonBar;
}(_react.Component);

DialogButtonBar.propTypes = {
    children: _react.PropTypes.node
};

//--------------------------------------------------------------------------
//
//  Easy-to-use Dialog
//
//--------------------------------------------------------------------------

/** An easy-to-use Dialog component with a title and button bar, and scroll pane for children */

var Dialog = exports.Dialog = function (_Component5) {
    _inherits(Dialog, _Component5);

    function Dialog() {
        var _ref2;

        var _temp2, _this5, _ret2;

        _classCallCheck(this, Dialog);

        for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
            args[_key2] = arguments[_key2];
        }

        return _ret2 = (_temp2 = (_this5 = _possibleConstructorReturn(this, (_ref2 = Dialog.__proto__ || Object.getPrototypeOf(Dialog)).call.apply(_ref2, [this].concat(args))), _this5), _this5.userDismissed = function () {
            var onDismiss = _this5.props.onDismiss;

            if (onDismiss) {
                onDismiss(_this5);
            }
        }, _temp2), _possibleConstructorReturn(_this5, _ret2);
    }

    _createClass(Dialog, [{
        key: 'render',
        value: function render() {
            var _props2 = this.props,
                className = _props2.className,
                title = _props2.title,
                buttons = _props2.buttons,
                children = _props2.children,
                ignoreEscapeKey = _props2.ignoreEscapeKey;


            var defaultButton = _react2.default.createElement(
                'button',
                { onClick: this.userDismissed },
                'Close'
            );
            var buttonArray = [].concat(buttons || defaultButton);

            // Doing this will avoid getting annoying messages from React about array keys
            var buttonBar = _react2.default.createElement.apply(_react2.default, [DialogButtonBar, {}].concat(_toConsumableArray(buttonArray)));

            return _react2.default.createElement(
                BasicDialog,
                { className: className, ignoreEscapeKey: ignoreEscapeKey, onDismiss: this.userDismissed },
                _react2.default.createElement(
                    DialogHeader,
                    null,
                    title
                ),
                _react2.default.createElement(
                    DialogContent,
                    null,
                    children
                ),
                buttonBar
            );
        }
    }]);

    return Dialog;
}(_react.Component);

Dialog.propTypes = {
    className: _react.PropTypes.string,
    title: _react.PropTypes.node,
    buttons: _react.PropTypes.node,
    children: _react.PropTypes.node,
    onDismiss: _react.PropTypes.func,
    ignoreEscapeKey: _react.PropTypes.bool
};
//# sourceMappingURL=Dialog.js.map
