'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TableHeader = exports.TableCell = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _TableRow = require('./TableRow');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Takes the place of a <TD>
 */
var TableCell = exports.TableCell = function (_Component) {
    _inherits(TableCell, _Component);

    function TableCell() {
        _classCallCheck(this, TableCell);

        return _possibleConstructorReturn(this, (TableCell.__proto__ || Object.getPrototypeOf(TableCell)).apply(this, arguments));
    }

    _createClass(TableCell, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                href = _props.href,
                linkTo = _props.linkTo,
                title = _props.title,
                className = _props.className,
                children = _props.children,
                restProps = _objectWithoutProperties(_props, ['href', 'linkTo', 'title', 'className', 'children']);

            var classNames = ['JTable-cell'];

            if (className) {
                classNames.push(className);
            }

            var _generateLink = (0, _TableRow.generateLink)('div', href, linkTo),
                linkProps = _generateLink.linkProps,
                tagOrComponent = _generateLink.tagOrComponent;

            var outerProps = _extends({}, restProps, linkProps, {
                className: classNames.join(' '),
                title: title
            });

            if (typeof title === 'undefined' && typeof children === 'string') {
                outerProps.title = children;
            }

            var wrappedChildren = _react2.default.createElement(
                'div',
                { className: 'JTable-cell-contents' },
                children
            );

            return _react2.default.createElement(tagOrComponent, outerProps, wrappedChildren);
        }
    }]);

    return TableCell;
}(_react.Component);

TableCell.propTypes = {
    children: _react.PropTypes.node,
    className: _react.PropTypes.string,
    href: _react.PropTypes.string,
    linkTo: _react.PropTypes.string,
    onClick: _react.PropTypes.func,
    style: _react.PropTypes.object,
    title: _react.PropTypes.string
};

/**
 * Takes the place of a single <TH>
 */
var TableHeader = exports.TableHeader = function TableHeader(props) {
    var className = props.className,
        children = props.children;


    var classNames = ['JTable-header'];

    if (className) {
        classNames.push(className);
    }

    var newProps = _extends({}, props, {
        children: undefined,
        className: classNames.join(' ')
    });

    return _react2.default.createElement(
        TableCell,
        newProps,
        children
    );
};

TableHeader.propTypes = {
    children: _react.PropTypes.node,
    className: _react.PropTypes.string,
    href: _react.PropTypes.string,
    linkTo: _react.PropTypes.string,
    onClick: _react.PropTypes.func,
    style: _react.PropTypes.object,
    title: _react.PropTypes.string
};
//# sourceMappingURL=TableCell.js.map
