"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var React = require("react");
var StatusIndicator_1 = require("../status/StatusIndicator");
var SvgSpinner_1 = require("../status/SvgSpinner");
var TruncatingLabel_1 = require("../TruncatingLabel");
var PipelineGraphModel_1 = require("./PipelineGraphModel");
var PipelineGraphLayout_1 = require("./PipelineGraphLayout");
// Generate a react key for a connection
function connectorKey(leftNode, rightNode) {
    return 'c_' + leftNode.key + '_to_' + rightNode.key;
}
/**
 *  @deprecated Don't use this, the latest version exists in the ux-widgets repo, and Blue Ocean also uses that now
 */
var PipelineGraph = /** @class */ (function (_super) {
    __extends(PipelineGraph, _super);
    function PipelineGraph(props) {
        var _this = _super.call(this, props) || this;
        _this.state = {
            nodeColumns: [],
            connections: [],
            bigLabels: [],
            smallLabels: [],
            measuredWidth: 0,
            measuredHeight: 0,
            layout: __assign({}, PipelineGraphModel_1.defaultLayout, props.layout),
            selectedStage: props.selectedStage,
        };
        return _this;
    }
    PipelineGraph.prototype.componentWillMount = function () {
        this.stagesUpdated(this.props.stages);
    };
    PipelineGraph.prototype.componentWillReceiveProps = function (nextProps) {
        var _this = this;
        var newState;
        var needsLayout = false;
        if (nextProps.layout != this.props.layout) {
            newState = __assign({}, newState, { layout: __assign({}, PipelineGraphModel_1.defaultLayout, this.props.layout) });
            needsLayout = true;
        }
        if (nextProps.selectedStage !== this.props.selectedStage) {
            // If we're just changing selectedStage, we don't need to re-generate the children
            newState = __assign({}, newState, { selectedStage: nextProps.selectedStage });
        }
        if (nextProps.stages !== this.props.stages) {
            needsLayout = true;
        }
        var doLayoutIfNeeded = function () {
            if (needsLayout) {
                _this.stagesUpdated(nextProps.stages);
            }
        };
        if (newState) {
            // If we need to update the state, then we'll delay any layout changes
            this.setState(newState, doLayoutIfNeeded);
        }
        else {
            doLayoutIfNeeded();
        }
    };
    /**
     * Main process for laying out the graph. Calls out to PipelineGraphLayout module.
     */
    PipelineGraph.prototype.stagesUpdated = function (newStages) {
        if (newStages === void 0) { newStages = []; }
        this.setState(PipelineGraphLayout_1.layoutGraph(newStages, this.state.layout));
    };
    /**
     * Generate the Component for a big label
     */
    PipelineGraph.prototype.renderBigLabel = function (details) {
        var _a = this.state.layout, nodeSpacingH = _a.nodeSpacingH, labelOffsetV = _a.labelOffsetV, connectorStrokeWidth = _a.connectorStrokeWidth, ypStart = _a.ypStart;
        var labelWidth = nodeSpacingH - connectorStrokeWidth * 2;
        var labelHeight = ypStart - labelOffsetV;
        var labelOffsetH = Math.floor(labelWidth / -2);
        // These are about layout more than appearance, so they should probably remain inline
        var bigLabelStyle = {
            position: 'absolute',
            width: labelWidth,
            maxHeight: labelHeight + 'px',
            textAlign: 'center',
            marginLeft: labelOffsetH,
        };
        var hasSequentialParallelStages = false;
        if (details.stage) {
            for (var _i = 0, _b = details.stage.children; _i < _b.length; _i++) {
                var stageChild = _b[_i];
                if (stageChild.seqContainerName) {
                    hasSequentialParallelStages = true;
                }
            }
        }
        var x = hasSequentialParallelStages ? details.x + PipelineGraphLayout_1.sequentialStagesLabelOffset / 2 : details.x;
        var bottom = this.state.measuredHeight - details.y + labelOffsetV;
        // These are about layout more than appearance, so they're inline
        var style = __assign({}, bigLabelStyle, { bottom: bottom + 'px', left: x + 'px' });
        var classNames = ['pipeline-big-label'];
        if (this.stageIsSelected(details.stage) || this.stageChildIsSelected(details.stage)) {
            classNames.push('selected');
        }
        return (React.createElement(TruncatingLabel_1.TruncatingLabel, { className: classNames.join(' '), style: style, key: details.key }, details.text));
    };
    /**
     * Generate the Component for a small label
     */
    PipelineGraph.prototype.renderSmallLabel = function (details) {
        var _a = this.state.layout, nodeSpacingH = _a.nodeSpacingH, nodeSpacingV = _a.nodeSpacingV, curveRadius = _a.curveRadius, connectorStrokeWidth = _a.connectorStrokeWidth, nodeRadius = _a.nodeRadius, smallLabelOffsetV = _a.smallLabelOffsetV;
        var smallLabelWidth = Math.floor(nodeSpacingH - 2 * curveRadius - 2 * connectorStrokeWidth); // Fit between lines
        var smallLabelHeight = Math.floor(nodeSpacingV - smallLabelOffsetV - nodeRadius - SvgSpinner_1.strokeWidth);
        var smallLabelOffsetH = Math.floor(smallLabelWidth * -0.5);
        var x = details.x + smallLabelOffsetH;
        var top = details.y + smallLabelOffsetV;
        // These are about layout more than appearance, so they're inline
        var style = {
            top: top,
            left: x,
            position: 'absolute',
            width: smallLabelWidth,
            maxHeight: smallLabelHeight,
            textAlign: 'center',
        };
        var classNames = ['pipeline-small-label'];
        if (details.stage && this.stageIsSelected(details.stage)) {
            classNames.push('selected');
        }
        return (React.createElement(TruncatingLabel_1.TruncatingLabel, { className: classNames.join(' '), style: style, key: details.key }, details.text));
    };
    /**
     * Generate the Component for a small label denoting the name of the container of a group of sequential parallel stages
     */
    PipelineGraph.prototype.renderSequentialContainerLabel = function (destNode, connectorStrokeWidth, midPointX, sequentialBranchesNames) {
        var seqContainerName = destNode.stage.seqContainerName;
        var containerStyle = {
            top: Math.ceil(destNode.y - connectorStrokeWidth * 2),
            left: midPointX + 30,
            position: 'absolute',
            maxWidth: PipelineGraphLayout_1.sequentialStagesLabelOffset,
            textAlign: 'center',
            overflow: 'hidden',
            textOverflow: 'ellipsis',
            background: 'white',
            padding: '0 7px',
            lineHeight: '1',
            whiteSpace: 'nowrap',
        };
        sequentialBranchesNames.push(React.createElement("div", { style: containerStyle, key: destNode.key + 'container', title: seqContainerName }, seqContainerName));
    };
    /**
     * Generate SVG for a composite connection, which may be to/from many nodes.
     *
     * Farms work out to other methods on self depending on the complexity of the line required. Adds all the SVG
     * components to the elements list.
     */
    PipelineGraph.prototype.renderCompositeConnection = function (connection, elements, sequentialBranchesNames) {
        var sourceNodes = connection.sourceNodes, destinationNodes = connection.destinationNodes, skippedNodes = connection.skippedNodes;
        if (skippedNodes.length === 0) {
            // Nothing too complicated, use the original connection drawing code
            this.renderBasicConnections(sourceNodes, destinationNodes, elements, sequentialBranchesNames);
        }
        else {
            this.renderSkippingConnections(sourceNodes, destinationNodes, skippedNodes, elements);
        }
    };
    /**
     * Connections between adjacent columns without any skipping.
     *
     * Adds all the SVG components to the elements list.
     */
    PipelineGraph.prototype.renderBasicConnections = function (sourceNodes, destinationNodes, elements, sequentialBranchesNames) {
        var _a = this.state.layout, connectorStrokeWidth = _a.connectorStrokeWidth, nodeSpacingH = _a.nodeSpacingH;
        var halfSpacingH = nodeSpacingH / 2;
        // Stroke props common to straight / curved connections
        var connectorStroke = {
            className: 'pipeline-connector',
            strokeWidth: connectorStrokeWidth,
        };
        this.renderHorizontalConnection(sourceNodes[0], destinationNodes[0], connectorStroke, elements);
        if (sourceNodes.length === 1 && destinationNodes.length === 1) {
            return; // No curves needed.
        }
        // Work out the extents of source and dest space
        var rightmostSource = sourceNodes[0].x;
        var leftmostDestination = destinationNodes[0].x;
        for (var i = 1; i < sourceNodes.length; i++) {
            rightmostSource = Math.max(rightmostSource, sourceNodes[i].x);
        }
        for (var i = 1; i < destinationNodes.length; i++) {
            leftmostDestination = Math.min(leftmostDestination, destinationNodes[i].x);
        }
        // console.log(''); // TODO: RM
        // console.log('sourceNodes', sourceNodes.map(node => `${node.name} (${node.x})`).join(', ')); // TODO: RM
        // console.log('rightmostSource',rightmostSource); // TODO: RM
        // console.log('destNodes', destinationNodes.map(node => `${node.name} (${node.x})`).join(', ')); // TODO: RM
        // console.log('leftmostDestination',leftmostDestination); // TODO: RM
        // Collapse from previous node(s) to top column node
        for (var _i = 0, _b = sourceNodes.slice(1); _i < _b.length; _i++) {
            var previousNode = _b[_i];
            var midPointX = Math.round((PipelineGraphModel_1.MATRIOSKA_PATHS ? previousNode.x : rightmostSource) + halfSpacingH);
            // console.log('collapse from',previousNode.name,'to',destinationNodes[0].name, 'mpx', midPointX); // TODO: RM
            this.renderBasicCurvedConnection(previousNode, destinationNodes[0], midPointX, elements);
        }
        for (var _c = 0, destinationNodes_1 = destinationNodes; _c < destinationNodes_1.length; _c++) {
            var destNode = destinationNodes_1[_c];
            if (!PipelineGraphModel_1.MATRIOSKA_PATHS && !destNode.isPlaceholder && destNode.stage && destNode.stage.seqContainerName) {
                var midPointX = Math.round(leftmostDestination - PipelineGraphLayout_1.sequentialStagesLabelOffset - halfSpacingH);
                this.renderSequentialContainerLabel(destNode, connectorStrokeWidth, midPointX, sequentialBranchesNames);
            }
        }
        // Expand from top previous node to column node(s)
        for (var _d = 0, _e = destinationNodes.slice(1); _d < _e.length; _d++) {
            var destNode = _e[_d];
            var computedLeftmostDestination = !destNode.isPlaceholder && destNode.stage && destNode.stage.seqContainerName
                ? leftmostDestination - PipelineGraphLayout_1.sequentialStagesLabelOffset
                : leftmostDestination;
            var midPointX = Math.round((PipelineGraphModel_1.MATRIOSKA_PATHS ? destNode.x : computedLeftmostDestination) - halfSpacingH);
            // console.log('expand from',sourceNodes[0].name,'to',destNode.name, 'mpx', midPointX); // TODO: RM
            this.renderBasicCurvedConnection(sourceNodes[0], destNode, midPointX, elements);
        }
    };
    /**
     * Renders a more complex connection, that "skips" one or more nodes
     *
     * Adds all the SVG components to the elements list.
     */
    PipelineGraph.prototype.renderSkippingConnections = function (sourceNodes, destinationNodes, skippedNodes, elements) {
        var _a = this.state.layout, connectorStrokeWidth = _a.connectorStrokeWidth, nodeRadius = _a.nodeRadius, terminalRadius = _a.terminalRadius, curveRadius = _a.curveRadius, nodeSpacingV = _a.nodeSpacingV, nodeSpacingH = _a.nodeSpacingH;
        var halfSpacingH = nodeSpacingH / 2;
        // Stroke props common to straight / curved connections
        var connectorStroke = {
            className: 'pipeline-connector',
            strokeWidth: connectorStrokeWidth,
        };
        var skipConnectorStroke = {
            className: 'pipeline-connector-skipped',
            strokeWidth: connectorStrokeWidth,
        };
        var lastSkippedNode = skippedNodes[skippedNodes.length - 1];
        var leftNode, rightNode;
        //--------------------------------------------------------------------------
        //  Draw the "ghost" connections to/from/between skipped nodes
        leftNode = sourceNodes[0];
        for (var _i = 0, skippedNodes_1 = skippedNodes; _i < skippedNodes_1.length; _i++) {
            rightNode = skippedNodes_1[_i];
            this.renderHorizontalConnection(leftNode, rightNode, skipConnectorStroke, elements);
            leftNode = rightNode;
        }
        this.renderHorizontalConnection(leftNode, destinationNodes[0], skipConnectorStroke, elements);
        //--------------------------------------------------------------------------
        //  Work out the extents of source and dest space
        var rightmostSource = sourceNodes[0].x;
        var leftmostDestination = destinationNodes[0].x;
        for (var i = 1; i < sourceNodes.length; i++) {
            rightmostSource = Math.max(rightmostSource, sourceNodes[i].x);
        }
        for (var i = 1; i < destinationNodes.length; i++) {
            leftmostDestination = Math.min(leftmostDestination, destinationNodes[i].x);
        }
        //--------------------------------------------------------------------------
        //  "Collapse" from the source node(s) down toward the first skipped
        leftNode = sourceNodes[0];
        rightNode = skippedNodes[0];
        for (var _b = 0, _c = sourceNodes.slice(1); _b < _c.length; _b++) {
            leftNode = _c[_b];
            var midPointX = Math.round((PipelineGraphModel_1.MATRIOSKA_PATHS ? leftNode.x : rightmostSource) + halfSpacingH);
            var leftNodeRadius_1 = leftNode.isPlaceholder ? terminalRadius : nodeRadius;
            var key_1 = connectorKey(leftNode, rightNode);
            var x1 = leftNode.x + leftNodeRadius_1 - SvgSpinner_1.strokeWidth / 2;
            var y1 = leftNode.y;
            var x2 = midPointX;
            var y2 = rightNode.y;
            var pathData_1 = "M " + x1 + " " + y1 + this.svgCurve(x1, y1, x2, y2, midPointX, curveRadius);
            elements.push(React.createElement("path", __assign({}, connectorStroke, { key: key_1, d: pathData_1, fill: "none" })));
        }
        //--------------------------------------------------------------------------
        //  "Expand" from the last skipped node toward the destination nodes
        leftNode = lastSkippedNode;
        rightNode = destinationNodes[0];
        for (var _d = 0, _e = destinationNodes.slice(1); _d < _e.length; _d++) {
            rightNode = _e[_d];
            var midPointX = Math.round((PipelineGraphModel_1.MATRIOSKA_PATHS ? rightNode.x : leftmostDestination) - halfSpacingH);
            var rightNodeRadius_1 = rightNode.isPlaceholder ? terminalRadius : nodeRadius;
            var key_2 = connectorKey(leftNode, rightNode);
            var x1 = midPointX;
            var y1 = leftNode.y;
            var x2 = rightNode.x - rightNodeRadius_1 + SvgSpinner_1.strokeWidth / 2;
            var y2 = rightNode.y;
            var pathData_2 = "M " + x1 + " " + y1 + this.svgCurve(x1, y1, x2, y2, midPointX, curveRadius);
            elements.push(React.createElement("path", __assign({}, connectorStroke, { key: key_2, d: pathData_2, fill: "none" })));
        }
        //--------------------------------------------------------------------------
        //  "Main" curve from top of source nodes, around skipped nodes, to top of dest nodes
        leftNode = sourceNodes[0];
        rightNode = destinationNodes[0];
        var leftNodeRadius = leftNode.isPlaceholder ? terminalRadius : nodeRadius;
        var rightNodeRadius = rightNode.isPlaceholder ? terminalRadius : nodeRadius;
        var key = connectorKey(leftNode, rightNode);
        var skipHeight = nodeSpacingV * 0.5;
        var controlOffsetUpper = curveRadius * 1.54;
        var controlOffsetLower = skipHeight * 0.257;
        var controlOffsetMid = skipHeight * 0.2;
        var inflectionOffset = Math.round(skipHeight * 0.7071); // cos(45º)-ish
        // Start point
        var p1x = leftNode.x + leftNodeRadius - SvgSpinner_1.strokeWidth / 2;
        var p1y = leftNode.y;
        // Begin curve down point
        var p2x = Math.round(skippedNodes[0].x - halfSpacingH);
        var p2y = p1y;
        var c1x = p2x + controlOffsetUpper;
        var c1y = p2y;
        // End curve down point
        var p4x = skippedNodes[0].x;
        var p4y = p1y + skipHeight;
        var c4x = p4x - controlOffsetLower;
        var c4y = p4y;
        // Curve down midpoint / inflection
        var p3x = skippedNodes[0].x - inflectionOffset;
        var p3y = skippedNodes[0].y + inflectionOffset;
        var c2x = p3x - controlOffsetMid;
        var c2y = p3y - controlOffsetMid;
        var c3x = p3x + controlOffsetMid;
        var c3y = p3y + controlOffsetMid;
        // Begin curve up point
        var p5x = lastSkippedNode.x;
        var p5y = p4y;
        var c5x = p5x + controlOffsetLower;
        var c5y = p5y;
        // End curve up point
        var p7x = Math.round(lastSkippedNode.x + halfSpacingH);
        var p7y = rightNode.y;
        var c8x = p7x - controlOffsetUpper;
        var c8y = p7y;
        // Curve up midpoint / inflection
        var p6x = lastSkippedNode.x + inflectionOffset;
        var p6y = lastSkippedNode.y + inflectionOffset;
        var c6x = p6x - controlOffsetMid;
        var c6y = p6y + controlOffsetMid;
        var c7x = p6x + controlOffsetMid;
        var c7y = p6y - controlOffsetMid;
        // End point
        var p8x = rightNode.x - rightNodeRadius + SvgSpinner_1.strokeWidth / 2;
        var p8y = rightNode.y;
        var pathData = "M " + p1x + " " + p1y +
            ("L " + p2x + " " + p2y) + // 1st horizontal
            ("C " + c1x + " " + c1y + " " + c2x + " " + c2y + " " + p3x + " " + p3y) + // Curve down (upper)
            ("C " + c3x + " " + c3y + " " + c4x + " " + c4y + " " + p4x + " " + p4y) + // Curve down (lower)
            ("L " + p5x + " " + p5y) + // 2nd horizontal
            ("C " + c5x + " " + c5y + " " + c6x + " " + c6y + " " + p6x + " " + p6y) + // Curve up (lower)
            ("C " + c7x + " " + c7y + " " + c8x + " " + c8y + " " + p7x + " " + p7y) + // Curve up (upper)
            ("L " + p8x + " " + p8y) + // Last horizontal
            '';
        elements.push(React.createElement("path", __assign({}, connectorStroke, { key: key, d: pathData, fill: "none" })));
    };
    /**
     * Simple straight connection.
     *
     * Adds all the SVG components to the elements list.
     */
    PipelineGraph.prototype.renderHorizontalConnection = function (leftNode, rightNode, connectorStroke, elements) {
        var _a = this.state.layout, nodeRadius = _a.nodeRadius, terminalRadius = _a.terminalRadius;
        var leftNodeRadius = leftNode.isPlaceholder ? terminalRadius : nodeRadius;
        var rightNodeRadius = rightNode.isPlaceholder ? terminalRadius : nodeRadius;
        var key = connectorKey(leftNode, rightNode);
        var x1 = leftNode.x + leftNodeRadius - SvgSpinner_1.strokeWidth / 2;
        var x2 = rightNode.x - rightNodeRadius + SvgSpinner_1.strokeWidth / 2;
        var y = leftNode.y;
        elements.push(React.createElement("line", __assign({}, connectorStroke, { key: key, x1: x1, y1: y, x2: x2, y2: y })));
    };
    /**
     * A direct curve between two nodes in adjacent columns.
     *
     * Adds all the SVG components to the elements list.
     */
    PipelineGraph.prototype.renderBasicCurvedConnection = function (leftNode, rightNode, midPointX, elements) {
        var _a = this.state.layout, nodeRadius = _a.nodeRadius, terminalRadius = _a.terminalRadius, curveRadius = _a.curveRadius, connectorStrokeWidth = _a.connectorStrokeWidth;
        var leftNodeRadius = leftNode.isPlaceholder ? terminalRadius : nodeRadius;
        var rightNodeRadius = rightNode.isPlaceholder ? terminalRadius : nodeRadius;
        var key = connectorKey(leftNode, rightNode);
        var leftPos = {
            x: leftNode.x + leftNodeRadius - SvgSpinner_1.strokeWidth / 2,
            y: leftNode.y,
        };
        var rightPos = {
            x: rightNode.x - rightNodeRadius + SvgSpinner_1.strokeWidth / 2,
            y: rightNode.y,
        };
        // Stroke props common to straight / curved connections
        var connectorStroke = {
            className: 'pipeline-connector',
            strokeWidth: connectorStrokeWidth,
        };
        var pathData = "M " + leftPos.x + " " + leftPos.y + this.svgCurve(leftPos.x, leftPos.y, rightPos.x, rightPos.y, midPointX, curveRadius);
        elements.push(React.createElement("path", __assign({}, connectorStroke, { key: key, d: pathData, fill: "none" })));
    };
    /**
     * Generates an SVG path string for the "vertical" S curve used to connect nodes in adjacent columns.
     */
    PipelineGraph.prototype.svgCurve = function (x1, y1, x2, y2, midPointX, curveRadius) {
        var verticalDirection = Math.sign(y2 - y1); // 1 == curve down, -1 == curve up
        var w1 = midPointX - curveRadius - x1 + curveRadius * verticalDirection;
        var w2 = x2 - curveRadius - midPointX - curveRadius * verticalDirection;
        var v = y2 - y1 - 2 * curveRadius * verticalDirection; // Will be -ive if curve up
        var cv = verticalDirection * curveRadius;
        return (" l " + w1 + " 0" + // first horizontal line
            (" c " + curveRadius + " 0 " + curveRadius + " " + cv + " " + curveRadius + " " + cv) + // turn
            (" l 0 " + v) + // vertical line
            (" c 0 " + cv + " " + curveRadius + " " + cv + " " + curveRadius + " " + cv) + // turn again
            (" l " + w2 + " 0") // second horizontal line
        );
    };
    /**
     * Generate the SVG elements to represent a node.
     *
     * Adds all the SVG components to the elements list.
     */
    PipelineGraph.prototype.renderNode = function (node, elements) {
        var _this = this;
        var nodeIsSelected = false;
        var _a = this.state.layout, nodeRadius = _a.nodeRadius, connectorStrokeWidth = _a.connectorStrokeWidth, terminalRadius = _a.terminalRadius;
        var key = node.key;
        var groupChildren = [];
        if (node.isPlaceholder === true) {
            groupChildren.push(React.createElement("circle", { r: terminalRadius, className: "pipeline-node-terminal" }));
        }
        else {
            var _b = node.stage, _c = _b.completePercent, completePercent = _c === void 0 ? 0 : _c, title = _b.title, state = _b.state;
            var resultClean = StatusIndicator_1.decodeResultValue(state);
            groupChildren.push(StatusIndicator_1.getGroupForResult(resultClean, completePercent, nodeRadius));
            if (title) {
                groupChildren.push(React.createElement("title", null, title));
            }
            nodeIsSelected = this.stageIsSelected(node.stage);
        }
        // Set click listener and link cursor only for nodes we want to be clickable
        var clickableProps = {};
        if (node.isPlaceholder === false && node.stage.state !== 'skipped') {
            clickableProps.cursor = 'pointer';
            clickableProps.onClick = function () { return _this.nodeClicked(node); };
        }
        // Add an invisible click/touch/mouseover target, coz the nodes are small and (more importantly)
        // many are hollow.
        groupChildren.push(React.createElement("circle", __assign({ r: nodeRadius + 2 * connectorStrokeWidth, className: "pipeline-node-hittarget", fillOpacity: "0", stroke: "none" }, clickableProps)));
        // Most of the nodes are in shared code, so they're rendered at 0,0. We transform with a <g> to position them
        var groupProps = {
            key: key,
            transform: "translate(" + node.x + "," + node.y + ")",
            className: nodeIsSelected ? 'pipeline-node-selected' : 'pipeline-node',
        };
        elements.push(React.createElement.apply(React, ['g', groupProps].concat(groupChildren)));
    };
    /**
     * Generates SVG for visual highlight to show which node is selected.
     *
     * Adds all the SVG components to the elements list.
     */
    PipelineGraph.prototype.renderSelectionHighlight = function (elements) {
        var _a = this.state.layout, nodeRadius = _a.nodeRadius, connectorStrokeWidth = _a.connectorStrokeWidth;
        var highlightRadius = Math.ceil(nodeRadius + 0.5 * connectorStrokeWidth + 1);
        var selectedNode;
        columnLoop: for (var _i = 0, _b = this.state.nodeColumns; _i < _b.length; _i++) {
            var column = _b[_i];
            for (var _c = 0, _d = column.rows; _c < _d.length; _c++) {
                var row = _d[_c];
                for (var _e = 0, row_1 = row; _e < row_1.length; _e++) {
                    var node = row_1[_e];
                    if (node.isPlaceholder === false && this.stageIsSelected(node.stage)) {
                        selectedNode = node;
                        break columnLoop;
                    }
                }
            }
        }
        if (selectedNode) {
            var transform = "translate(" + selectedNode.x + " " + selectedNode.y + ")";
            elements.push(React.createElement("g", { className: "pipeline-selection-highlight", transform: transform, key: "selection-highlight" },
                React.createElement("circle", { className: "white-highlight", r: highlightRadius - 2, strokeWidth: 10 }),
                React.createElement("circle", { r: highlightRadius, strokeWidth: 2 })));
        }
    };
    /**
     * Is this stage currently selected?
     */
    PipelineGraph.prototype.stageIsSelected = function (stage) {
        var selectedStage = this.state.selectedStage;
        return (selectedStage && stage && selectedStage.id === stage.id) || false;
    };
    /**
     * Is this any child of this stage currently selected?
     */
    PipelineGraph.prototype.stageChildIsSelected = function (stage) {
        if (stage) {
            var children = stage.children;
            var selectedStage = this.state.selectedStage;
            if (children && selectedStage) {
                for (var _i = 0, children_1 = children; _i < children_1.length; _i++) {
                    var childStage = children_1[_i];
                    var currentStage = childStage;
                    while (currentStage) {
                        if (currentStage.id === selectedStage.id) {
                            return true;
                        }
                        currentStage = currentStage.nextSibling;
                    }
                }
            }
        }
        return false;
    };
    PipelineGraph.prototype.nodeClicked = function (node) {
        if (node.isPlaceholder === false && node.stage.state !== 'skipped') {
            var stage = node.stage;
            var listener = this.props.onNodeClick;
            if (listener) {
                listener(stage.name, stage.id);
            }
            // Update selection
            this.setState({ selectedStage: stage });
        }
    };
    PipelineGraph.prototype.render = function () {
        var _this = this;
        var _a = this.state, _b = _a.nodeColumns, nodeColumns = _b === void 0 ? [] : _b, _c = _a.connections, connections = _c === void 0 ? [] : _c, _d = _a.bigLabels, bigLabels = _d === void 0 ? [] : _d, _e = _a.smallLabels, smallLabels = _e === void 0 ? [] : _e, measuredWidth = _a.measuredWidth, measuredHeight = _a.measuredHeight;
        // Without these we get fire, so they're hardcoded
        var outerDivStyle = {
            position: 'relative',
            overflow: 'visible',
        };
        var visualElements = []; // Buffer for children of the SVG
        var sequentialBranchesNames = [];
        connections.forEach(function (connection) {
            _this.renderCompositeConnection(connection, visualElements, sequentialBranchesNames);
        });
        this.renderSelectionHighlight(visualElements);
        for (var _i = 0, nodeColumns_1 = nodeColumns; _i < nodeColumns_1.length; _i++) {
            var column = nodeColumns_1[_i];
            for (var _f = 0, _g = column.rows; _f < _g.length; _f++) {
                var row = _g[_f];
                for (var _h = 0, row_2 = row; _h < row_2.length; _h++) {
                    var node = row_2[_h];
                    this.renderNode(node, visualElements);
                }
            }
        }
        return (React.createElement("div", { style: outerDivStyle, className: "PipelineGraph" },
            React.createElement("svg", { width: measuredWidth, height: measuredHeight }, visualElements),
            bigLabels.map(function (label) { return _this.renderBigLabel(label); }),
            smallLabels.map(function (label) { return _this.renderSmallLabel(label); }),
            sequentialBranchesNames));
    };
    return PipelineGraph;
}(React.Component));
exports.PipelineGraph = PipelineGraph;
