'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _components = require('../components');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('List', module).add('general', function () {
    return _react2.default.createElement(General, null);
}).add('renderers', function () {
    return _react2.default.createElement(Renderers, null);
}).add('keyboard & focus', function () {
    return _react2.default.createElement(KeyboardFocus, null);
}).add('constraining', function () {
    return _react2.default.createElement(Constraining, null);
}).add('disabled', function () {
    return _react2.default.createElement(Disabled, null);
}).add('callbacks', function () {
    return _react2.default.createElement(Callbacks, null);
});

var simpleData = ['A', 'B', 'C', 'D', 'EFGHIJKLMNOPQRSTUV', 'W', 'X', 'Y', 'Z'];

var container = {
    padding: 10,
    maxWidth: 300
};

var list = {
    maxHeight: 200
};

function General() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: container },
            _react2.default.createElement(
                'p',
                null,
                'Default w/ max height set'
            ),
            _react2.default.createElement(_components.List, { data: simpleData, style: list })
        ),
        _react2.default.createElement(
            'div',
            { style: container },
            _react2.default.createElement(
                'p',
                null,
                'with defaultStyles=false'
            ),
            _react2.default.createElement(_components.List, { data: simpleData, style: list, defaultStyles: false })
        ),
        _react2.default.createElement(
            'div',
            { style: container },
            _react2.default.createElement(
                'p',
                null,
                'with defaultSelection'
            ),
            _react2.default.createElement(_components.List, { data: simpleData, style: list, defaultSelection: 'C' })
        ),
        _react2.default.createElement(
            'div',
            { style: container },
            _react2.default.createElement(
                'p',
                null,
                'Default w/ no height'
            ),
            _react2.default.createElement(_components.List, { data: simpleData })
        )
    );
}

// renderers

function Renderer1(props) {
    /* eslint-disable react/prop-types */
    return _react2.default.createElement(
        'div',
        { style: { padding: 20, fontSize: 20 } },
        'Large ',
        props.listItem
    );
    /* eslint-enable react/prop-types */
}

function Renderers() {
    /* eslint-disable react/prop-types */
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: container },
            _react2.default.createElement(
                'p',
                null,
                'inline renderer w/ default styles'
            ),
            _react2.default.createElement(
                _components.List,
                { data: simpleData, style: list },
                _react2.default.createElement(function (props) {
                    return _react2.default.createElement(
                        'div',
                        null,
                        '#',
                        props.listIndex,
                        ' - ',
                        props.listItem
                    );
                })
            )
        ),
        _react2.default.createElement(
            'div',
            { style: container },
            _react2.default.createElement(
                'p',
                null,
                'custom renderer w/ no styles'
            ),
            _react2.default.createElement(
                _components.List,
                { data: simpleData, style: list, defaultStyles: false },
                _react2.default.createElement(Renderer1, null)
            )
        )
    );
    /* eslint-enable react/prop-types */
}

function KeyboardFocus() {
    var buttonStyle = { margin: 10, flexShrink: 0 };
    var outer = {
        display: 'flex',
        flexDirection: 'column',
        justifyContent: 'space-around',
        alignItems: 'center',
        padding: 10,
        height: 400
    };

    return _react2.default.createElement(
        'div',
        { style: outer },
        _react2.default.createElement(
            'p',
            null,
            'This layout is useful for demonstrating keyboard accessibility and focus behavior.'
        ),
        _react2.default.createElement(
            'button',
            { style: buttonStyle },
            'Test 1'
        ),
        _react2.default.createElement(_components.List, { data: simpleData, style: _extends({}, list, { maxWidth: 300 }) }),
        _react2.default.createElement(
            'button',
            { style: buttonStyle },
            'Test 2'
        )
    );
}

var WIDTH = 200;
var HEIGHT = 250;

function Constraining() {
    var outer = { display: 'flex' };
    var inner = { width: WIDTH + 50, padding: 10 };
    var title = { height: 50 };

    var constrain = { maxWidth: WIDTH, maxHeight: HEIGHT };
    var explicit = { width: WIDTH, height: HEIGHT };

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: outer },
            _react2.default.createElement(
                'div',
                { style: inner },
                _react2.default.createElement(
                    'p',
                    { style: title },
                    'width / height directly on List'
                ),
                _react2.default.createElement(_components.List, { data: simpleData, style: explicit })
            ),
            _react2.default.createElement(
                'div',
                { style: inner },
                _react2.default.createElement(
                    'p',
                    { style: title },
                    'maxWidth / maxHeight directly on List'
                ),
                _react2.default.createElement(_components.List, { data: simpleData, style: constrain })
            ),
            _react2.default.createElement(
                'div',
                { style: inner },
                _react2.default.createElement(
                    'p',
                    { style: title },
                    'List anchored to parent via absolute positioning'
                ),
                _react2.default.createElement(
                    'div',
                    { style: _extends({}, constrain, { height: HEIGHT, position: 'relative' }) },
                    _react2.default.createElement(_components.List, { data: simpleData, style: { position: 'absolute', top: 0, bottom: 0 } })
                )
            ),
            _react2.default.createElement(
                'div',
                { style: inner },
                _react2.default.createElement(
                    'p',
                    { style: title },
                    'maxWidth / maxHeight on parent container (flexbox)'
                ),
                _react2.default.createElement(
                    'div',
                    { style: _extends({}, constrain, { display: 'flex' }) },
                    _react2.default.createElement(_components.List, { data: simpleData })
                )
            )
        ),
        _react2.default.createElement(
            'div',
            { style: outer },
            _react2.default.createElement(
                'div',
                { style: inner },
                _react2.default.createElement(
                    'p',
                    { style: title },
                    'maxWidth / maxHeight on parent container (not flexbox)'
                ),
                _react2.default.createElement(
                    'div',
                    { style: constrain },
                    _react2.default.createElement(_components.List, { data: simpleData })
                )
            )
        )
    );
}

function Disabled() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: container },
            _react2.default.createElement(
                'p',
                null,
                'props.disabled = true'
            ),
            _react2.default.createElement(_components.List, { data: simpleData, style: list, disabled: true })
        ),
        _react2.default.createElement(
            'div',
            { style: container },
            _react2.default.createElement(
                'p',
                null,
                'nested in fieldset.disabled=true'
            ),
            _react2.default.createElement(
                'fieldset',
                { disabled: 'disabled' },
                _react2.default.createElement(_components.List, { data: simpleData, style: list })
            )
        )
    );
}

function Callbacks() {
    return _react2.default.createElement(
        'div',
        { style: container },
        _react2.default.createElement(
            'p',
            null,
            'onItemSelect'
        ),
        _react2.default.createElement(_components.List, {
            data: simpleData,
            style: list,
            onItemSelect: function onItemSelect(index, item) {
                return console.log(index, item);
            }
        })
    );
}
//# sourceMappingURL=ListStories.js.map
