'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TableHeaderRow = exports.TableRow = undefined;

var _TableRow$propTypes, _TableHeaderRow$propT;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.generateLink = generateLink;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRouter = require('react-router');

var _ = require('../');

var _JTable = require('./JTable');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Generate the props and optionally override the element tag / component required to implement a link on a row or cell.
 */
function generateLink(defaultTagOrComponent, href, linkTo) {
    var isLink = false;
    var linkProps = undefined;
    var tagOrComponent = defaultTagOrComponent;

    if (typeof href === 'string' && href.length > 0) {
        isLink = true;
        // We switch to an <A> instead of <DIV> so the user can middle-click
        tagOrComponent = 'a';
        linkProps = { href: href };
    } else if (typeof linkTo === 'string' && linkTo.length > 0) {
        isLink = true;
        // Use <Link> instead of <A> for local BO URLs because we don't know the base url here
        tagOrComponent = _reactRouter.Link;
        linkProps = { to: linkTo };
    }

    return {
        isLink: isLink,
        linkProps: linkProps,
        tagOrComponent: tagOrComponent
    };
}

function processChildren(children, columns) {
    // First filter the children to strip any falsy values dropped by logic in our parent's render() method
    var filteredChildren = [];

    _react.Children.forEach(children, function (child) {
        if (child) {
            filteredChildren.push(child);
        }
    });

    var numChildren = filteredChildren.length;
    var processedColumns = Array.isArray(columns) ? columns.concat() : [];

    // Make sure we have the right number of columns
    if (processedColumns.length !== numChildren) {
        console.warn('TableRow - received', numChildren, 'children, but', processedColumns.length, 'columns!');

        // Add generic columns if there's some missing
        while (processedColumns.length < numChildren) {
            processedColumns.push({ name: '', width: 100, isFlexible: true });
        }
    }

    return filteredChildren.map(function (child, i) {
        var elementStyle = child.props.style || {};
        var newStyle = _extends({}, elementStyle);
        var columnDescription = processedColumns[i];

        // Calc width including "spacing" because it needs to actually be padding in order to support whole-row anchors
        var colWidth = columnDescription.width;
        if (i === 0 || i === numChildren - 1) {
            colWidth += _JTable.TABLE_LEFT_RIGHT_PADDING + _JTable.TABLE_COLUMN_SPACING / 2;
        } else {
            colWidth += _JTable.TABLE_COLUMN_SPACING;
        }
        newStyle.flexBasis = colWidth;

        // Add or remove space on flexible columns in proportion to comparative widths
        newStyle.flexGrow = newStyle.flexShrink = columnDescription.isFlexible ? colWidth : 0;

        return _react2.default.cloneElement(child, { style: newStyle });
    });
}

/**
 * A table row, stand-in for <TR>. Can take a href="" attribute, which will render the row as an anchor instead of a
 * div.
 */

var TableRow = exports.TableRow = function (_Component) {
    _inherits(TableRow, _Component);

    function TableRow(props) {
        _classCallCheck(this, TableRow);

        return _possibleConstructorReturn(this, (TableRow.__proto__ || Object.getPrototypeOf(TableRow)).call(this, props));
    }

    _createClass(TableRow, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                className = _props.className,
                children = _props.children,
                columns = _props.columns,
                href = _props.href,
                linkTo = _props.linkTo,
                restProps = _objectWithoutProperties(_props, ['className', 'children', 'columns', 'href', 'linkTo']);

            var useRollOver = this.props.useRollover;
            var classNames = ['JTable-row'];

            if (className) {
                classNames.push(className);
            }

            var newChildren = processChildren(children, columns);

            var _generateLink = generateLink('div', href, linkTo),
                isLink = _generateLink.isLink,
                linkProps = _generateLink.linkProps,
                tagOrComponent = _generateLink.tagOrComponent;

            var props = _extends({}, restProps, linkProps, {
                className: className
            });

            if (isLink) {
                classNames.push('JTable-row--href');

                if (useRollOver !== false) {
                    // ^ Explicitly setting to false (not falsy) will disable rollover
                    classNames.push('JTable-row--rollOver');
                }
            } else {
                if (useRollOver) {
                    classNames.push('JTable-row--rollOver');
                }
            }

            props.className = classNames.join(' ');

            return _react2.default.createElement.apply(_react2.default, [tagOrComponent, props].concat(_toConsumableArray(newChildren)));
        }
    }]);

    return TableRow;
}(_react.Component);

TableRow.propTypes = (_TableRow$propTypes = {
    onClick: _react.PropTypes.func,
    className: _react.PropTypes.string,
    children: _react.PropTypes.node
}, _defineProperty(_TableRow$propTypes, 'onClick', _react.PropTypes.func), _defineProperty(_TableRow$propTypes, 'href', _react.PropTypes.string), _defineProperty(_TableRow$propTypes, 'linkTo', _react.PropTypes.string), _defineProperty(_TableRow$propTypes, 'columns', _react.PropTypes.array), _defineProperty(_TableRow$propTypes, 'useRollover', _react.PropTypes.bool), _TableRow$propTypes);

var TableHeaderRow = exports.TableHeaderRow = function TableHeaderRow(props) {
    var columns = props.columns || [];
    var children = columns.map(function (col) {
        return _react2.default.createElement(
            _.TableHeader,
            null,
            col.name
        );
    });

    return _react2.default.createElement.apply(_react2.default, [TableRow, props].concat(_toConsumableArray(children)));
};

TableHeaderRow.propTypes = (_TableHeaderRow$propT = {
    onClick: _react.PropTypes.func,
    className: _react.PropTypes.string,
    children: _react.PropTypes.node
}, _defineProperty(_TableHeaderRow$propT, 'onClick', _react.PropTypes.func), _defineProperty(_TableHeaderRow$propT, 'href', _react.PropTypes.string), _defineProperty(_TableHeaderRow$propT, 'linkTo', _react.PropTypes.string), _defineProperty(_TableHeaderRow$propT, 'columns', _react.PropTypes.array), _defineProperty(_TableHeaderRow$propT, 'useRollover', _react.PropTypes.bool), _TableHeaderRow$propT);
//# sourceMappingURL=TableRow.js.map
