'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.getGlyphFor = getGlyphFor;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _SvgSpinner = require('./SvgSpinner');

var _SVG = require('../SVG');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// These were mostly taken from SVG and pre-translated
var questionMarkPath = 'M-0.672,4.29 L0.753,4.29 L0.753,5.78 L-0.672,5.78 L-0.672,4.29 Z M-2.21,-3.94 ' + 'C-1.63,-4.57 -0.830,-4.88 0.187,-4.88 C1.13,-4.88 1.88,-4.61 2.45,-4.07 C3.01,-3.54 3.30,-2.85 3.30,-2.01 ' + 'C3.30,-1.51 3.19,-1.10 2.99,-0.782 C2.78,-0.467 2.36,-0.00346 1.73,0.608 C1.27,1.05 0.972,1.43 0.836,1.74 ' + 'C0.700,2.04 0.632,2.50 0.632,3.10 L-0.644,3.10 C-0.644,2.42 -0.562,1.87 -0.400,1.45 ' + 'C-0.238,1.03 0.118,0.553 0.668,0.0133 L1.24,-0.553 C1.41,-0.715 1.55,-0.885 1.66,-1.06 ' + 'C1.85,-1.37 1.94,-1.69 1.94,-2.03 C1.94,-2.50 1.80,-2.90 1.52,-3.25 C1.24,-3.59 0.782,-3.76 0.137,-3.76 ' + 'C-0.660,-3.76 -1.21,-3.47 -1.52,-2.87 C-1.69,-2.54 -1.79,-2.07 -1.81,-1.45 L-3.09,-1.45 ' + 'C-3.09,-2.48 -2.80,-3.31 -2.21,-3.94 L-2.21,-3.94 Z';

var hollowCirclePath = 'M 0,-6 A 6,6 0 0 1 0,6 A 6,6 0 0 1 0,-6 m 0,1.3 A 4,4 0 0 0 0,4.7 A 4,4 0 0 0 0,-4.7';

var checkMarkPoints = '-2.00 2.80 -4.80 0.00 -5.73 0.933 -2.00 4.67 6.00 -3.33 5.07 -4.27';

var crossPoints = '4.67 -3.73 3.73 -4.67 0 -0.94 -3.73 -4.67 -4.67 -3.73 -0.94 0 -4.67 3.73 -3.73 4.67 0 0.94 ' + '3.73 4.67 4.67 3.73 0.94 0';

/**
    Returns a glyph (as <g>) for specified result type. Centered at 0,0, scaled for 24px icons.
 */
function getGlyphFor(result) {
    // NB: If we start resizing these things, we'll need to use radius/12 to
    // generate a "scale" transform for the group

    switch (result) {
        case 'aborted':
            return _react2.default.createElement(
                'g',
                { className: 'result-status-glyph' },
                _react2.default.createElement('polygon', { points: '-5 -1 5 -1 5 1 -5 1' })
            );
        case 'paused':
            // "||"
            // 8px 9.3px
            return _react2.default.createElement(
                'g',
                { className: 'result-status-glyph' },
                _react2.default.createElement('polygon', { points: '-4,-4.65 -4,4.65 -4,4.65 -1.5,4.65 -1.5,-4.65' }),
                _react2.default.createElement('polygon', { points: '4,-4.65 1.5,-4.65 1.5,-4.65 1.5,4.65 4,4.65' })
            );
        case 'unstable':
            // "!"
            return _react2.default.createElement(
                'g',
                { className: 'result-status-glyph' },
                _react2.default.createElement('polygon', { points: '-1 -5 1 -5 1 1 -1 1' }),
                _react2.default.createElement('polygon', { points: '-1 3 1 3 1 5 -1 5' })
            );
        case 'success':
            // check-mark
            return _react2.default.createElement(
                'g',
                { className: 'result-status-glyph' },
                _react2.default.createElement('polygon', { points: checkMarkPoints })
            );
        case 'failure':
            // "X"
            return _react2.default.createElement(
                'g',
                { className: 'result-status-glyph' },
                _react2.default.createElement('polygon', { points: crossPoints })
            );
        case 'running':
            // hollow circle
            var radius = 12 - 0.5 * _SvgSpinner.strokeWidth;
            var d = (0, _SVG.describeArcAsPath)(0, 0, radius, 0, 120);
            return _react2.default.createElement(
                'g',
                { className: 'result-status-glyph', transform: 'scale(0.5)' },
                _react2.default.createElement('circle', { stroke: '#a7c7f2', fill: 'none', cx: '0', cy: '0', r: radius, strokeWidth: _SvgSpinner.strokeWidth }),
                _react2.default.createElement('path', { stroke: 'white', className: 'spin', fill: 'none', strokeWidth: _SvgSpinner.strokeWidth, d: d })
            );
        case 'not_built':
        case 'queued':
            // hollow circle
            return _react2.default.createElement(
                'g',
                { className: 'result-status-glyph' },
                _react2.default.createElement('path', { transform: 'scale(0.9)', d: hollowCirclePath })
            );
    }
    // "?" for unknown / invalid
    return _react2.default.createElement(
        'g',
        { className: 'result-status-glyph' },
        _react2.default.createElement('path', { d: questionMarkPath })
    );
}

var SvgStatus = function (_Component) {
    _inherits(SvgStatus, _Component);

    function SvgStatus() {
        _classCallCheck(this, SvgStatus);

        return _possibleConstructorReturn(this, (SvgStatus.__proto__ || Object.getPrototypeOf(SvgStatus)).apply(this, arguments));
    }

    _createClass(SvgStatus, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                result = _props.result,
                _props$radius = _props.radius,
                radius = _props$radius === undefined ? 12 : _props$radius;


            return _react2.default.createElement(
                'g',
                { className: 'svgResultStatus' },
                _react2.default.createElement('circle', { cx: '0', cy: '0', r: radius, className: 'circle-bg ' + result }),
                getGlyphFor(result)
            );
        }
    }]);

    return SvgStatus;
}(_react.Component);

exports.default = SvgStatus;


SvgStatus.propTypes = {
    result: _react.PropTypes.string,
    radius: _react.PropTypes.number
};
//# sourceMappingURL=SvgStatus.js.map
