'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _components = require('../components');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('FormElement', module).add('general', function () {
    return _react2.default.createElement(General, null);
}).add('layouts', function () {
    return _react2.default.createElement(Layouts, null);
}).add('disabled', function () {
    return _react2.default.createElement(Disabled, null);
}).add('errors', function () {
    return _react2.default.createElement(Errors, null);
}).add('sizes', function () {
    return _react2.default.createElement(Sizes, null);
});

var style = {
    padding: 10
};

function General() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'With title'
            ),
            _react2.default.createElement(
                _components.FormElement,
                { title: 'Title' },
                _react2.default.createElement(_components.TextInput, { defaultValue: 'Child' })
            )
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'With showDivider'
            ),
            _react2.default.createElement(
                _components.FormElement,
                { title: 'Title', showDivider: true },
                _react2.default.createElement(_components.RadioButtonGroup, { options: ['A', 'B', 'C'] })
            )
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'With errorMessage'
            ),
            _react2.default.createElement(
                _components.FormElement,
                { title: 'TextInput', errorMessage: 'error' },
                _react2.default.createElement(_components.TextInput, { defaultValue: 'error' })
            ),
            _react2.default.createElement(
                _components.FormElement,
                { title: 'PasswordInput', errorMessage: 'error' },
                _react2.default.createElement(_components.PasswordInput, { defaultValue: 'error' })
            ),
            _react2.default.createElement(
                _components.FormElement,
                { title: 'TextArea', errorMessage: 'error' },
                _react2.default.createElement(_components.TextArea, { defaultValue: 'error' })
            )
        )
    );
}

function Layouts() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Multiple children lay out horizontally by default...'
            ),
            _react2.default.createElement(
                _components.FormElement,
                { title: 'Details' },
                _react2.default.createElement(_components.TextInput, { placeholder: 'name' }),
                _react2.default.createElement(
                    'button',
                    null,
                    'Save'
                )
            )
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                '... or use verticalLayout=true'
            ),
            _react2.default.createElement(
                _components.FormElement,
                { title: 'Details', verticalLayout: true },
                _react2.default.createElement(_components.TextArea, { placeholder: 'name' }),
                _react2.default.createElement(
                    'button',
                    null,
                    'Save'
                )
            )
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Nesting FormElements within FormElements'
            ),
            _react2.default.createElement(
                _components.FormElement,
                { title: 'Legal Name', showDivider: true },
                _react2.default.createElement(
                    _components.FormElement,
                    { title: 'First Name' },
                    _react2.default.createElement(_components.TextInput, { defaultValue: 'Michael' })
                ),
                _react2.default.createElement(
                    _components.FormElement,
                    { title: 'Last Name' },
                    _react2.default.createElement(_components.TextInput, { defaultValue: 'Garibaldi' })
                )
            )
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Nesting FormElements within FormElements with verticalLayout=true'
            ),
            _react2.default.createElement(
                _components.FormElement,
                { title: 'Authentication Details', showDivider: true, verticalLayout: true, errorMessage: 'fill in fields below' },
                _react2.default.createElement(
                    _components.FormElement,
                    { title: 'Username' },
                    _react2.default.createElement(_components.TextInput, { defaultValue: 'michael.garibaldi' })
                ),
                _react2.default.createElement(
                    _components.FormElement,
                    { title: 'Password' },
                    _react2.default.createElement(_components.PasswordInput, { defaultValue: 'peekaboo' })
                ),
                _react2.default.createElement(
                    _components.FormElement,
                    { title: 'Secret Key' },
                    _react2.default.createElement(_components.TextArea, null)
                )
            )
        )
    );
}

// Sizes

// show several FormElements w/ TextInputs to demonstrate FormElement spacing
function TextInputGroup(props) {
    var count = props.count || 3;
    var divider = props.divider;
    var array = new Array(count);

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.Children.map(array, function (item, index) {
            return _react2.default.createElement(
                _components.FormElement,
                { title: 'Element #' + index, showDivider: divider },
                _react2.default.createElement(_components.TextInput, { defaultValue: 'Child #' + index })
            );
        })
    );
}

TextInputGroup.propTypes = {
    count: _react.PropTypes.number,
    divider: _react.PropTypes.bool
};

function Sizes() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using no layout'
            ),
            _react2.default.createElement(TextInputGroup, null)
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-small', style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using layout-small'
            ),
            _react2.default.createElement(TextInputGroup, null)
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-medium', style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using layout-medium'
            ),
            _react2.default.createElement(TextInputGroup, null)
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-large', style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using layout-large'
            ),
            _react2.default.createElement(TextInputGroup, null)
        ),
        _react2.default.createElement(
            'h1',
            { style: style },
            'With Dividers'
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-small', style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using layout-small'
            ),
            _react2.default.createElement(TextInputGroup, { divider: true })
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-medium', style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using layout-medium'
            ),
            _react2.default.createElement(TextInputGroup, { divider: true })
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-large', style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using layout-large'
            ),
            _react2.default.createElement(TextInputGroup, { divider: true })
        )
    );
}

function Disabled() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Elements are disabled when nested in <fieldset disabled>'
            ),
            _react2.default.createElement(
                'fieldset',
                { disabled: true },
                _react2.default.createElement(
                    _components.FormElement,
                    null,
                    _react2.default.createElement(
                        'button',
                        null,
                        'Button'
                    )
                ),
                _react2.default.createElement(
                    _components.FormElement,
                    null,
                    _react2.default.createElement(_components.TextInput, { placeholder: 'TextInput' })
                ),
                _react2.default.createElement(
                    _components.FormElement,
                    null,
                    _react2.default.createElement(_components.PasswordInput, { placeholder: 'PasswordInput' })
                ),
                _react2.default.createElement(
                    _components.FormElement,
                    null,
                    _react2.default.createElement(_components.TextArea, { placeholder: 'TextArea' })
                ),
                _react2.default.createElement(
                    _components.FormElement,
                    null,
                    _react2.default.createElement(_components.Checkbox, { label: 'Checkbox' })
                ),
                _react2.default.createElement(
                    _components.FormElement,
                    null,
                    _react2.default.createElement(_components.Favorite, { label: 'Favorite' })
                ),
                _react2.default.createElement(
                    _components.FormElement,
                    null,
                    _react2.default.createElement(_components.RadioButtonGroup, { options: ['Radio', 'Button', 'Group'] })
                ),
                _react2.default.createElement(
                    _components.FormElement,
                    null,
                    _react2.default.createElement(_components.Dropdown, { placeholder: 'Dropdown', options: ['Drop', 'Down', 'Menu'] })
                )
            )
        )
    );
}

// Errors

function FormError(props) {
    return _react2.default.createElement(
        _components.FormElement,
        { title: 'Title', errorMessage: 'with error message' },
        props.children
    );
}

FormError.propTypes = {
    children: _react.PropTypes.node
};

function Errors() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                FormError,
                null,
                _react2.default.createElement(_components.TextInput, { defaultValue: 'TextInput with error' })
            )
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                FormError,
                null,
                _react2.default.createElement(_components.TextArea, { defaultValue: 'TextArea with error' })
            )
        )
    );
}
//# sourceMappingURL=FormElementStories.js.map
