'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _WithContext = require('./WithContext');

var _WithContext2 = _interopRequireDefault(_WithContext);

var _components = require('../components');

var _Icon = require('../components/Icon');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

//--------------------------------------------------------------------------
//
//  Story index
//
//--------------------------------------------------------------------------

(0, _storybook.storiesOf)('JTable', module).add('Basic', basic).add('Manual', manual).add('Component column header', headerComponent);

//--------------------------------------------------------------------------
//
//  Data
//
//--------------------------------------------------------------------------

var rowHeaders = ["Score", "Batsman", "For", "Against", "Innings", "Test", "Ground", "Date", ""];
var rowData = [["400", "Brian Lara", "West Indies", "England", "1st", "4th", "Antigua Recreation Ground, St John's", "10 April 2004"], ["380", "Matthew Hayden", "Australia", "Zimbabwe", "1st", "1st", "WACA Ground, Perth", "9 October 2003"], ["375", "Brian Lara", "West Indies", "England", "1st", "5th", "Antigua Recreation Ground, St John's", "16 April 1994"], ["374", "Mahela Jayawardene", "Sri Lanka", "South Africa", "1st", "1st", "Sinhalese S.C., Colombo", "27 July 2006"], ["365", "Garfield Sobers", "West Indies", "Pakistan", "1st", "3rd", "Sabina Park, Kingston", "26 February 1958"], ["364", "Len Hutton", "England", "Australia", "1st", "5th", "The Oval, London", "20 August 1938"], ["340", "Sanath Jayasuriya", "Sri Lanka", "India", "1st", "1st", "R. Premadasa Stadium, Colombo", "2 August 1997"], ["337", "Hanif Mohammad", "Pakistan", "West Indies", "2nd", "1st", "Kensington Oval, Bridgetown", "17 January 1958"], ["336", "Wally Hammond", "England", "New Zealand", "1st", "2nd", "Eden Park, Auckland", "31 March 1933"], ["334", "Donald Bradman", "Australia", "England", "1st", "3rd", "Headingley, Leeds", "11 July 1930"], ["334", "Mark Taylor", "Australia", "Pakistan", "1st", "2nd", "Arbab Niaz Stadium, Peshawar", "15 October 1998"]];
var colWidths = [40, 200, 90, 90, 40, 40, 200, 130, 90];

//--------------------------------------------------------------------------
//
//  Helpers
//
//--------------------------------------------------------------------------

function container() {

    var style = {
        margin: "1em"
    };

    var ctx = {
        router: {
            createHref: function createHref(x) {
                return "/context-url-base" + x;
            }
        }
    };

    for (var _len = arguments.length, children = Array(_len), _key = 0; _key < _len; _key++) {
        children[_key] = arguments[_key];
    }

    return _react2.default.createElement(
        _WithContext2.default,
        { context: ctx },
        _react2.default.createElement.apply(_react2.default, ['div', { style: style }].concat(children))
    );
}

function rowClicked(e) {
    e.stopPropagation();
    e.preventDefault();
    var tag = e.currentTarget.attributes.getNamedItem('data-tag');
    console.log('rowClicked', tag ? tag.value : 'missing data-tag');
}

function cellClicked(e) {
    e.stopPropagation();
    e.preventDefault();
    var tag = e.currentTarget.attributes.getNamedItem('data-tag');
    console.log('cellClicked', tag ? tag.value : 'missing data-tag');
}

function renderRow(rowData) {
    var key = rowData[1] + rowData[0];

    var boxStyle = {
        width: '24px',
        height: '24px',
        background: '#ccc',
        overflow: 'hidden'
    };

    return _react2.default.createElement(
        _components.TableRow,
        { onClick: rowClicked, key: key, 'data-tag': 'row-' + key },
        rowData.map(renderCell),
        _react2.default.createElement(
            _components.TableCell,
            { className: 'TableCell--actions' },
            _react2.default.createElement(_Icon.Icon, { size: 24, icon: 'ActionHistory', color: '#cccccc' }),
            _react2.default.createElement('div', { style: boxStyle }),
            _react2.default.createElement(_Icon.Icon, { size: 24, icon: 'ActionDelete', color: '#cccccc' })
        )
    );
}

function renderCell(cellValue, i) {
    return _react2.default.createElement(
        _components.TableCell,
        { key: i },
        cellValue
    );
}

//--------------------------------------------------------------------------
//
//  Story renderers
//
//--------------------------------------------------------------------------

function basic() {

    var rows = rowData.map(renderRow);
    var columns = [];

    for (var i = 0; i < colWidths.length; i++) {
        columns.push(_components.JTable.column(colWidths[i], rowHeaders[i]));
    }

    columns[1].isFlexible = true;
    columns[6].isFlexible = true;

    return container(_react2.default.createElement(
        _components.JTable,
        { columns: columns },
        _react2.default.createElement(_components.TableHeaderRow, null),
        rows
    ));
}

function headerComponent() {

    var rows = rowData.map(renderRow);
    var columns = [];

    for (var i = 0; i < colWidths.length; i++) {
        columns.push(_components.JTable.column(colWidths[i], rowHeaders[i]));
    }

    columns[1].isFlexible = true;
    columns[6].isFlexible = true;

    columns[6].name = _react2.default.createElement(
        'button',
        null,
        'Button As Header'
    );

    return container(_react2.default.createElement(
        _components.JTable,
        { columns: columns },
        _react2.default.createElement(_components.TableHeaderRow, null),
        rows
    ));
}

function manual() {

    var w = 100;

    var columns = [_components.JTable.column(w), _components.JTable.column(w), _components.JTable.column(w), _components.JTable.column(w), _components.JTable.column(w), _components.JTable.column(w), _components.JTable.column(w * 2)];

    var style = {
        marginTop: '1em',
        marginBottom: '2em',
        width: '800px'
    };

    var style2 = {
        marginTop: '1em',
        marginBottom: '2em'
    };

    return container(_react2.default.createElement(
        'h3',
        null,
        'Manual headers, row links'
    ), _react2.default.createElement(
        _components.JTable,
        { columns: columns, style: style },
        _react2.default.createElement(
            _components.TableRow,
            null,
            _react2.default.createElement(
                _components.TableHeader,
                null,
                'X'
            ),
            _react2.default.createElement(
                _components.TableHeader,
                null,
                'Y'
            ),
            _react2.default.createElement(
                _components.TableHeader,
                null,
                'AND'
            ),
            _react2.default.createElement(
                _components.TableHeader,
                null,
                'OR'
            ),
            false // Need to make sure you can drop columns based on some logic!
            ,
            _react2.default.createElement(
                _components.TableHeader,
                null,
                'XOR'
            ),
            _react2.default.createElement(
                _components.TableHeader,
                null,
                'NAND'
            ),
            _react2.default.createElement(
                _components.TableHeader,
                null,
                'Nonsense'
            )
        ),
        null // Make sure we can have optional rows, as well as optional columns!
        ,
        _react2.default.createElement(
            _components.TableRow,
            { onClick: rowClicked, 'data-tag': 'row-first', href: 'http://www.example.org/alpha/' },
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            null // Need to make sure you can drop columns based on some logic!
            ,
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'Alpha'
            )
        ),
        _react2.default.createElement(
            _components.TableRow,
            { onClick: rowClicked, 'data-tag': 'row-2', href: 'http://www.example.org/bravo/' },
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'this space intentionally left blank'
            )
        ),
        _react2.default.createElement(
            _components.TableRow,
            { onClick: rowClicked, 'data-tag': 'row-3', href: 'http://www.example.org/charlie/' },
            _react2.default.createElement(
                _components.TableCell,
                null,
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'Charlie don\'t surf'
            )
        ),
        _react2.default.createElement(
            _components.TableRow,
            { onClick: rowClicked, 'data-tag': 'row-last', linkTo: '/app-specific-url/foo' },
            _react2.default.createElement(
                _components.TableCell,
                null,
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                { onClick: cellClicked, 'data-tag': 'row-last-cell-and' },
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                { onClick: cellClicked, 'data-tag': 'row-last-cell-or' },
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                { onClick: cellClicked, 'data-tag': 'row-last-cell-xor' },
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                { onClick: cellClicked, 'data-tag': 'row-last-cell-nand' },
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                { onClick: cellClicked, 'data-tag': 'row-last-cell-last' },
                '<Link>'
            )
        )
    ), _react2.default.createElement(
        'h3',
        null,
        'Some Links, some useRollover'
    ), _react2.default.createElement(
        _components.JTable,
        { columns: columns, style: style2 },
        _react2.default.createElement(
            _components.TableRow,
            null,
            _react2.default.createElement(
                _components.TableHeader,
                null,
                'X'
            ),
            _react2.default.createElement(
                _components.TableHeader,
                null,
                'Y'
            ),
            _react2.default.createElement(
                _components.TableHeader,
                null,
                'AND'
            ),
            _react2.default.createElement(
                _components.TableHeader,
                null,
                'OR'
            ),
            _react2.default.createElement(
                _components.TableHeader,
                null,
                'XOR'
            ),
            _react2.default.createElement(
                _components.TableHeader,
                null,
                'NAND'
            ),
            _react2.default.createElement(
                _components.TableHeader,
                null,
                'Comment'
            )
        ),
        _react2.default.createElement(
            _components.TableRow,
            { linkTo: '/app-link' },
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'Link'
            )
        ),
        _react2.default.createElement(
            _components.TableRow,
            { href: 'http://www.example.org/bravo/', useRollover: false },
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'Link, useRollover=false'
            )
        ),
        _react2.default.createElement(
            _components.TableRow,
            null,
            _react2.default.createElement(
                _components.TableCell,
                null,
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'No link'
            )
        ),
        _react2.default.createElement(
            _components.TableRow,
            { useRollover: true },
            _react2.default.createElement(
                _components.TableCell,
                { href: 'http://example.org/a' },
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                { href: 'http://example.org/a' },
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                { href: 'http://example.org/a' },
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                { linkTo: '/app-link' },
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                { linkTo: '/app-link' },
                'False'
            ),
            _react2.default.createElement(
                _components.TableCell,
                { linkTo: '/app-link' },
                'True'
            ),
            _react2.default.createElement(
                _components.TableCell,
                null,
                'Cell links only, useRollover=true'
            )
        )
    ));
}
//# sourceMappingURL=JTableStories.js.map
