'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ExpandablePath = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Icon = require('./Icon');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Created by cmeyers on 10/4/16.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var SHOW_LABEL_CLASS = 'show-label';
var SHOW_FOLDER_CLASS = 'show-folder';

/**
 * ExpandablePath displays a list of path elements with built-in truncation logic.
 * By default the first, last and second-to-last path items will always be shown as labels.
 * Intermediate path items will be displayed as folder icons and expand to show labels on hover.
 *
 * Props:
 *      className: CSS class to put on root element
 *      iconSize: for folder icons, in pixels
 *      path: a forward-slash delimited string of a path, e.g. 'folder1/folder2/pipeline'
 *      hideFirst: set to true to display the first path element as a folder.
 *      uriDecode: set to true to show uri-decoded form of each path element.
 */

var ExpandablePath = exports.ExpandablePath = function (_Component) {
    _inherits(ExpandablePath, _Component);

    function ExpandablePath() {
        _classCallCheck(this, ExpandablePath);

        return _possibleConstructorReturn(this, (ExpandablePath.__proto__ || Object.getPrototypeOf(ExpandablePath)).apply(this, arguments));
    }

    _createClass(ExpandablePath, [{
        key: 'render',
        value: function render() {
            var _this2 = this;

            if (!this.props.path) {
                return null;
            }

            var pathElements = this.props.path.split('/');
            var extraClass = this.props.className || '';

            return _react2.default.createElement(
                'span',
                { className: 'expandable-path ' + extraClass },
                _react2.default.createElement(
                    'ul',
                    { className: 'path-list' },
                    pathElements.map(function (pathElem, index, elements) {
                        var isFirst = index === 0;
                        var isSecondLast = index + 1 === elements.length - 1;
                        var isLast = index + 1 === elements.length;

                        var label = _this2.props.uriDecode ? decodeURIComponent(pathElem) : pathElem;

                        var displayClass = SHOW_FOLDER_CLASS;

                        if (isFirst && !_this2.props.hideFirst || isSecondLast || isLast) {
                            displayClass = SHOW_LABEL_CLASS;
                        }

                        return _react2.default.createElement(
                            'li',
                            { key: index, className: 'path-item ' + displayClass },
                            _this2.props.showIcon && _react2.default.createElement(_Icon.Icon, { size: _this2.props.iconSize, icon: 'FileFolder' }),
                            _react2.default.createElement(
                                'span',
                                { className: 'path-text' },
                                label.trim()
                            ),
                            _react2.default.createElement(
                                'span',
                                { className: 'separator' },
                                '\xA0/\xA0'
                            )
                        );
                    })
                )
            );
        }
    }], [{
        key: 'replaceLastPathElement',

        /**
         * Replace the last element in 'path' with 'label'.
         * Helpful for transforming a path to include a friendly display name.
         *
         * @param {string} path
         * @param {string} label
         * @returns {string}
         */
        value: function replaceLastPathElement(path, label) {
            return path ? path.split('/').slice(0, -1).concat(label).join('/') : '';
        }
    }]);

    return ExpandablePath;
}(_react.Component);

ExpandablePath.propTypes = {
    className: _react.PropTypes.string,
    iconSize: _react.PropTypes.number,
    showIcon: _react.PropTypes.bool,
    path: _react.PropTypes.string,
    hideFirst: _react.PropTypes.bool,
    uriDecode: _react.PropTypes.bool
};

ExpandablePath.defaultProps = {
    iconSize: 16,
    showIcon: true,
    hideFirst: false,
    uriDecode: true
};
//# sourceMappingURL=ExpandablePath.js.map
