'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TextInput = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Icon = require('../Icon');

var _TextControl = require('./TextControl');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// wraps the Icon in a div to provide consistent cursor behavior
function NestedIcon(props) {
    return _react2.default.createElement(
        'div',
        { className: 'TextInput-icon ' + props.className },
        _react2.default.createElement(_Icon.Icon, { icon: props.icon })
    );
}

NestedIcon.propTypes = {
    className: _react.PropTypes.string,
    icon: _react.PropTypes.string
};

var TextInput = exports.TextInput = function (_React$Component) {
    _inherits(TextInput, _React$Component);

    function TextInput() {
        _classCallCheck(this, TextInput);

        return _possibleConstructorReturn(this, (TextInput.__proto__ || Object.getPrototypeOf(TextInput)).apply(this, arguments));
    }

    _createClass(TextInput, [{
        key: 'render',
        value: function render() {
            var classLeft = this.props.iconLeft ? 'u-icon-left' : '';
            var classRight = this.props.iconRight ? 'u-icon-right' : '';
            var ariaLabel = this.props['aria-label'] || this.props.placeholder;

            return _react2.default.createElement(
                _TextControl.TextControl,
                _extends({}, this.props, { className: 'TextInput ' + this.props.className + ' ' + classLeft + ' ' + classRight }),
                classLeft && _react2.default.createElement(NestedIcon, { className: classLeft, icon: this.props.iconLeft }),
                _react2.default.createElement('input', _extends({ 'aria-label': ariaLabel, type: 'text', className: 'TextInput-control' }, { name: this.props.name })),
                classRight && _react2.default.createElement(NestedIcon, { className: classRight, icon: this.props.iconRight })
            );
        }
    }]);

    return TextInput;
}(_react2.default.Component);

TextInput.propTypes = {
    className: _react.PropTypes.string,
    name: _react.PropTypes.string,
    placeholder: _react.PropTypes.string,
    defaultValue: _react.PropTypes.string,
    disabled: _react.PropTypes.bool,
    iconLeft: _react.PropTypes.string,
    iconRight: _react.PropTypes.string,
    onChange: _react.PropTypes.func,
    onBlur: _react.PropTypes.func,
    'aria-label': _react.PropTypes.string
};

TextInput.defaultProps = {
    className: ''
};
//# sourceMappingURL=TextInput.js.map
