'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.JTable = exports.TABLE_COLUMN_SPACING = exports.TABLE_LEFT_RIGHT_PADDING = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TABLE_LEFT_RIGHT_PADDING = exports.TABLE_LEFT_RIGHT_PADDING = 23; // 24 inc border
var TABLE_COLUMN_SPACING = exports.TABLE_COLUMN_SPACING = 32;
// !!!IMPORTANT!!! Don't change the above consts without changing jtable.less to match!

/**
 * Table component, rendered using divs and display:flex rather than HTML tables, because that gives us better control
 * over layout, and allows us to do things like making a whole row an anchor, etc.
 */
var JTable = exports.JTable = function (_Component) {
    _inherits(JTable, _Component);

    _createClass(JTable, null, [{
        key: 'column',

        /**
         * Just a simple helper
         */
        value: function column(width) {
            var name = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
            var isFlexible = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

            return { name: name, width: width, isFlexible: isFlexible };
        }
    }]);

    function JTable(props) {
        _classCallCheck(this, JTable);

        var _this = _possibleConstructorReturn(this, (JTable.__proto__ || Object.getPrototypeOf(JTable)).call(this, props));

        _this.state = { columns: [] };
        return _this;
    }

    _createClass(JTable, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
            this.processColumns(this.props.columns);
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            if (nextProps.columns !== this.props.columns) {
                this.processColumns(nextProps.columns);
            }
        }
    }, {
        key: 'processColumns',
        value: function processColumns(propColumns) {
            if (propColumns == null) {
                propColumns = [];
            }

            if (!Array.isArray(propColumns)) {
                propColumns = [propColumns]; // Assuming a single column passed in
            }

            var hasFlexibleColumn = false;
            var processedColumns = propColumns.map(function (input) {
                var colName = '';

                if (input.name && _react2.default.isValidElement(input.name)) {
                    colName = input.name;
                } else if (input.name !== null) {
                    colName = String(input.name);
                }

                var result = {
                    name: colName,
                    width: parseInt(input.width),
                    isFlexible: !!input.isFlexible
                };

                hasFlexibleColumn = hasFlexibleColumn || result.isFlexible;

                if (isNaN(result.width)) {
                    // Make a wild stab at it
                    result.width = Math.floor(1000 / propColumns.length);
                }

                return result;
            });

            // If no flexible columns specified, we make them all flexible, or they'll get cut off / last column stretches
            if (!hasFlexibleColumn) {
                var _iteratorNormalCompletion = true;
                var _didIteratorError = false;
                var _iteratorError = undefined;

                try {
                    for (var _iterator = processedColumns[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                        var col = _step.value;

                        col.isFlexible = true;
                    }
                } catch (err) {
                    _didIteratorError = true;
                    _iteratorError = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion && _iterator.return) {
                            _iterator.return();
                        }
                    } finally {
                        if (_didIteratorError) {
                            throw _iteratorError;
                        }
                    }
                }
            }

            this.setState({ columns: processedColumns });
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                className = _props.className,
                children = _props.children,
                _props$noMaxWidth = _props.noMaxWidth,
                noMaxWidth = _props$noMaxWidth === undefined ? false : _props$noMaxWidth,
                restProps = _objectWithoutProperties(_props, ['className', 'children', 'noMaxWidth']);

            var classNames = ['JTable'];

            if (!noMaxWidth) {
                classNames.push('u-table-maxwidth');
            }

            if (className) {
                classNames.push.apply(classNames, _toConsumableArray(className.split(/\s+/)));
            }

            var newChildProps = {
                columns: this.state.columns
            };

            var newChildren = [];

            _react.Children.forEach(children, function (child) {
                if (child) {
                    newChildren.push(_react2.default.cloneElement(child, newChildProps));
                }
            });
            // div element does not know anything about columns, to prevent warnings remove columns from props
            if (restProps.columns) {
                delete restProps.columns;
            }
            var newProps = _extends({}, restProps, {
                className: classNames.join(' ')
            });

            return _react2.default.createElement.apply(_react2.default, ['div', newProps].concat(newChildren));
        }
    }]);

    return JTable;
}(_react.Component);

JTable.propTypes = {
    onClick: _react.PropTypes.func,
    className: _react.PropTypes.string,
    children: _react.PropTypes.node,
    style: _react.PropTypes.object,
    columns: _react.PropTypes.array,
    noMaxWidth: _react.PropTypes.bool
};
//# sourceMappingURL=JTable.js.map
