'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.strokeWidth = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _SVG = require('../SVG');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var strokeWidth = exports.strokeWidth = 3.5; // px. Maybe we can fetch this from CSS at runtime in the future

var SvgSpinner = function (_Component) {
    _inherits(SvgSpinner, _Component);

    function SvgSpinner() {
        var _ref;

        var _temp, _this, _ret;

        _classCallCheck(this, SvgSpinner);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = SvgSpinner.__proto__ || Object.getPrototypeOf(SvgSpinner)).call.apply(_ref, [this].concat(args))), _this), _this.infiniteLoadingTimer = function () {
            _this.infiniteRotateDegrees += 1.5;

            if (_this.infiniteRotateDegrees >= 360) {
                _this.infiniteRotateDegrees = 0;
            }

            _this.animatedElement.setAttribute('transform', 'rotate(' + _this.infiniteRotateDegrees + ')');
            _this.requestAnimationFrameId = requestAnimationFrame(_this.infiniteLoadingTimer);
        }, _temp), _possibleConstructorReturn(_this, _ret);
    }

    _createClass(SvgSpinner, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
            this.infiniteRotationRunning = false;
            this.infiniteRotateDegrees = 0;
            this.isEdgeOrIE = !!window.MSInputMethodContext && !!document.documentMode || window.navigator.userAgent.indexOf('Edge') > -1;
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            cancelAnimationFrame(this.requestAnimationFrameId);
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            var result = this.props.result;

            var radius = (this.props.radius || 12) - 0.5 * strokeWidth; // No "inside" stroking in SVG`

            var percentage = this.props.percentage;
            var groupClasses = ['progress-spinner', result];

            if (result === 'queued') {
                percentage = 0;
            } else if (result === 'not_built' || result === 'skipped') {
                percentage = 0;
            } else if (typeof percentage !== 'number' || isNaN(percentage) || percentage < 0) {
                percentage = 0;
            } else if (percentage === 100) {
                groupClasses.push('pc-over-100');
                percentage = 0;
            } else if (percentage > 100) {
                groupClasses.push('spin');
                percentage = 25;

                if (!this.infiniteRotationRunning && this.isEdgeOrIE) {
                    requestAnimationFrame(this.infiniteLoadingTimer);

                    this.infiniteRotationRunning = true;
                }
            }

            var rotate = percentage / 100 * 360;
            var d = (0, _SVG.describeArcAsPath)(0, 0, radius, 0, rotate);

            var innerRadius = radius / 3;

            return _react2.default.createElement(
                'g',
                { className: groupClasses.join(' '), ref: function ref(c) {
                        return _this2.animatedElement = c;
                    } },
                _react2.default.createElement('circle', { cx: '0', cy: '0', r: radius, strokeWidth: strokeWidth }),
                _react2.default.createElement('circle', { className: 'inner', cx: '0', cy: '0', r: innerRadius }),
                percentage ? _react2.default.createElement('path', { className: result, fill: 'none', strokeWidth: strokeWidth, d: d }) : null
            );
        }
    }]);

    return SvgSpinner;
}(_react.Component);

exports.default = SvgSpinner;


SvgSpinner.propTypes = {
    percentage: _react.PropTypes.number,
    radius: _react.PropTypes.number,
    result: _react.PropTypes.string
};
//# sourceMappingURL=SvgSpinner.js.map
