'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _PasswordInput = require('../components/forms/PasswordInput');

var _TextInput = require('../components/forms/TextInput');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('TextInput', module).add('general', function () {
    return _react2.default.createElement(General, null);
}).add('icons', function () {
    return _react2.default.createElement(Icons, null);
}).add('callbacks', function () {
    return _react2.default.createElement(Callbacks, null);
}).add('sizes', function () {
    return _react2.default.createElement(Sizes, null);
}).add('sizes - icons', function () {
    return _react2.default.createElement(SizesIcons, null);
});

var style = { padding: 10 };
var name = { name: 'testTextInput' };

function General() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Default'
            ),
            _react2.default.createElement(_TextInput.TextInput, null)
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Disabled'
            ),
            _react2.default.createElement(_TextInput.TextInput, { disabled: true })
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Placeholder'
            ),
            _react2.default.createElement(_TextInput.TextInput, { placeholder: 'This is a placeholder.' })
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Placeholder'
            ),
            _react2.default.createElement(_TextInput.TextInput, { defaultValue: 'I have a default value.' })
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Password'
            ),
            _react2.default.createElement(_PasswordInput.PasswordInput, { defaultValue: 'I have a default value.' })
        )
    );
}

function Icons() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'None'
            ),
            _react2.default.createElement(_TextInput.TextInput, null)
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Left'
            ),
            _react2.default.createElement(_TextInput.TextInput, { iconLeft: 'ActionSearch' })
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Right'
            ),
            _react2.default.createElement(_TextInput.TextInput, { iconRight: 'NavigationClose' })
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Both'
            ),
            _react2.default.createElement(_TextInput.TextInput, { iconLeft: 'ActionSearch', iconRight: 'NavigationClose' })
        )
    );
}

function Callbacks() {
    return _react2.default.createElement(
        'div',
        { style: style },
        _react2.default.createElement(_TextInput.TextInput, _extends({}, name, {
            onChange: function onChange(val) {
                return console.log('onChange', val);
            },
            onBlur: function onBlur(val) {
                return console.log('onBlur', val);
            }
        }))
    );
}

function Sizes() {
    var style2 = { padding: '20px 10px' };
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style2 },
            _react2.default.createElement(_TextInput.TextInput, _extends({ placeholder: 'TextInput using no layout' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_PasswordInput.PasswordInput, _extends({ placeholder: 'PasswordInput using no layout' }, name))
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-small', style: style2 },
            _react2.default.createElement(_TextInput.TextInput, _extends({ placeholder: 'TextInput using layout-small' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_PasswordInput.PasswordInput, _extends({ placeholder: 'PasswordInput using layout-small' }, name))
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-medium', style: style2 },
            _react2.default.createElement(_TextInput.TextInput, _extends({ placeholder: 'TextInput using layout-medium' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_PasswordInput.PasswordInput, _extends({ placeholder: 'PasswordInput using layout-medium' }, name))
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-large', style: style2 },
            _react2.default.createElement(_TextInput.TextInput, _extends({ placeholder: 'TextInput using layout-large' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_PasswordInput.PasswordInput, _extends({ placeholder: 'PasswordInput using layout-large' }, name))
        )
    );
}

function SizesIcons() {
    var style2 = { padding: '20px 10px' };
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style2 },
            _react2.default.createElement(_TextInput.TextInput, _extends({ placeholder: 'no layout' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_TextInput.TextInput, _extends({ iconLeft: 'search', placeholder: 'no layout' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_TextInput.TextInput, _extends({ iconRight: 'close', placeholder: 'no layout' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_TextInput.TextInput, _extends({ iconLeft: 'search', iconRight: 'close', placeholder: 'no layout' }, name))
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-small', style: style2 },
            _react2.default.createElement(_TextInput.TextInput, _extends({ placeholder: 'layout-small' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_TextInput.TextInput, _extends({ iconLeft: 'search', placeholder: 'layout-small' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_TextInput.TextInput, _extends({ iconRight: 'close', placeholder: 'layout-small' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_TextInput.TextInput, _extends({ iconLeft: 'search', iconRight: 'close', placeholder: 'layout-small' }, name))
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-medium', style: style2 },
            _react2.default.createElement(_TextInput.TextInput, _extends({ placeholder: 'layout-medium' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_TextInput.TextInput, _extends({ iconLeft: 'search', placeholder: 'layout-medium' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_TextInput.TextInput, _extends({ iconRight: 'close', placeholder: 'layout-medium' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_TextInput.TextInput, _extends({ iconLeft: 'search', iconRight: 'close', placeholder: 'layout-medium' }, name))
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-large', style: style2 },
            _react2.default.createElement(_TextInput.TextInput, _extends({ placeholder: 'layout-large' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_TextInput.TextInput, _extends({ iconLeft: 'search', placeholder: 'layout-large' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_TextInput.TextInput, _extends({ iconRight: 'close', placeholder: 'layout-large' }, name)),
            _react2.default.createElement('br', null),
            ' ',
            _react2.default.createElement('br', null),
            _react2.default.createElement(_TextInput.TextInput, _extends({ iconLeft: 'search', iconRight: 'close', placeholder: 'layout-large' }, name))
        )
    );
}
//# sourceMappingURL=TextInputStories.js.map
