/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.api;

import io.jenkins.plugins.checks.api.ChecksAction;
import io.jenkins.plugins.checks.api.ChecksConclusion;
import io.jenkins.plugins.checks.api.ChecksOutput;
import io.jenkins.plugins.checks.api.ChecksStatus;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ChecksDetails {
    private final String name;
    private final ChecksStatus status;
    private final String detailsURL;
    private final LocalDateTime startedAt;
    private final ChecksConclusion conclusion;
    private final LocalDateTime completedAt;
    private final ChecksOutput output;
    private final List<ChecksAction> actions;

    private ChecksDetails(String name, ChecksStatus status, String detailsURL, LocalDateTime startedAt, ChecksConclusion conclusion, LocalDateTime completedAt, ChecksOutput output, List<ChecksAction> actions) {
        this.name = name;
        this.status = status;
        this.detailsURL = detailsURL;
        this.startedAt = startedAt;
        this.conclusion = conclusion;
        this.completedAt = completedAt;
        this.output = output;
        this.actions = actions;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public ChecksStatus getStatus() {
        return this.status;
    }

    public Optional<String> getDetailsURL() {
        return Optional.ofNullable(this.detailsURL);
    }

    public Optional<LocalDateTime> getStartedAt() {
        return Optional.ofNullable(this.startedAt);
    }

    public ChecksConclusion getConclusion() {
        return this.conclusion;
    }

    public Optional<LocalDateTime> getCompletedAt() {
        return Optional.ofNullable(this.completedAt);
    }

    public Optional<ChecksOutput> getOutput() {
        return Optional.ofNullable(this.output);
    }

    public List<ChecksAction> getActions() {
        return this.actions;
    }

    public String toString() {
        return "ChecksDetails{name='" + this.name + '\'' + ", detailsURL='" + this.detailsURL + '\'' + ", status=" + (Object)((Object)this.status) + ", conclusion=" + (Object)((Object)this.conclusion) + ", startedAt=" + this.startedAt + ", completedAt=" + this.completedAt + ", output=" + this.output + ", actions=" + this.actions + '}';
    }

    public static class ChecksDetailsBuilder {
        private String name;
        private ChecksStatus status;
        private String detailsURL;
        private LocalDateTime startedAt;
        private ChecksConclusion conclusion = ChecksConclusion.NONE;
        private LocalDateTime completedAt;
        private ChecksOutput output;
        private List<ChecksAction> actions = new ArrayList<ChecksAction>();

        public ChecksDetailsBuilder withName(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public ChecksDetailsBuilder withStatus(ChecksStatus status) {
            this.status = Objects.requireNonNull(status);
            return this;
        }

        public ChecksDetailsBuilder withDetailsURL(String detailsURL) {
            this.detailsURL = Objects.requireNonNull(detailsURL);
            return this;
        }

        public ChecksDetailsBuilder withStartedAt(LocalDateTime startedAt) {
            this.startedAt = Objects.requireNonNull(startedAt);
            return this;
        }

        public ChecksDetailsBuilder withConclusion(ChecksConclusion conclusion) {
            this.conclusion = Objects.requireNonNull(conclusion);
            return this;
        }

        public ChecksDetailsBuilder withCompletedAt(LocalDateTime completedAt) {
            this.completedAt = Objects.requireNonNull(completedAt);
            return this;
        }

        public ChecksDetailsBuilder withOutput(ChecksOutput output) {
            this.output = new ChecksOutput(Objects.requireNonNull(output));
            return this;
        }

        public ChecksDetailsBuilder withActions(List<ChecksAction> actions) {
            this.actions = new ArrayList<ChecksAction>((Collection)Objects.requireNonNull(actions));
            return this;
        }

        public ChecksDetailsBuilder addAction(ChecksAction action) {
            this.actions.add(Objects.requireNonNull(action));
            return this;
        }

        public ChecksDetails build() {
            return new ChecksDetails(this.name, this.status, this.detailsURL, this.startedAt, this.conclusion, this.completedAt, this.output, Collections.unmodifiableList(this.actions));
        }
    }
}

