/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.api;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class TruncatedString {
    @NonNull
    private final List<String> chunks;
    @NonNull
    private final String truncationText;
    private final boolean truncateStart;
    private final boolean chunkOnNewlines;

    private TruncatedString(@NonNull List<String> chunks, @NonNull String truncationText, boolean truncateStart, boolean chunkOnNewlines) {
        this.chunks = Collections.unmodifiableList(Objects.requireNonNull(chunks));
        this.truncationText = Objects.requireNonNull(truncationText);
        this.truncateStart = truncateStart;
        this.chunkOnNewlines = chunkOnNewlines;
    }

    static TruncatedString fromString(String string) {
        return new Builder().setChunkOnNewlines().addText(string).build();
    }

    public String toString() {
        return String.join((CharSequence)"", this.chunks);
    }

    private List<String> getChunks() {
        if (this.chunkOnNewlines) {
            return Arrays.asList(String.join((CharSequence)"", this.chunks).split("(?<=\r?\n)"));
        }
        return new ArrayList<String>(this.chunks);
    }

    @Deprecated
    public String build(int maxSize) {
        return this.build(maxSize, false);
    }

    public String buildByBytes(int maxSize) {
        return this.build(maxSize, false);
    }

    public String buildByChars(int maxSize) {
        return this.build(maxSize, true);
    }

    private String build(int maxSize, boolean chunkOnChars) {
        List<String> parts = this.getChunks();
        if (this.truncateStart) {
            Collections.reverse(parts);
        }
        List<String> truncatedParts = parts.stream().collect(new Joiner(this.truncationText, maxSize, chunkOnChars));
        if (this.truncateStart) {
            Collections.reverse(truncatedParts);
        }
        return String.join((CharSequence)"", truncatedParts);
    }

    public static class Builder {
        private String truncationText = "Output truncated.";
        private boolean truncateStart = false;
        private boolean chunkOnNewlines = false;
        private final List<String> chunks = new ArrayList<String>();

        public TruncatedString build() {
            return new TruncatedString(this.chunks, this.truncationText, this.truncateStart, this.chunkOnNewlines);
        }

        public Builder addText(@NonNull String text) {
            this.chunks.add(Objects.requireNonNull(text));
            return this;
        }

        public Builder withTruncationText(@NonNull String truncationText) {
            this.truncationText = Objects.requireNonNull(truncationText);
            return this;
        }

        public Builder setTruncateStart() {
            this.truncateStart = true;
            return this;
        }

        public Builder setChunkOnNewlines() {
            this.chunkOnNewlines = true;
            return this;
        }
    }

    private static class Joiner
    implements Collector<String, Accumulator, List<String>> {
        private final int maxLength;
        private final String truncationText;
        private final boolean chunkOnChars;

        Joiner(String truncationText, int maxLength, boolean chunkOnChars) {
            this.truncationText = truncationText;
            this.maxLength = maxLength;
            this.chunkOnChars = chunkOnChars;
            if (maxLength < this.getLength(truncationText)) {
                throw new IllegalArgumentException("Maximum length is less than truncation text.");
            }
        }

        private int getLength(String text) {
            return this.chunkOnChars ? text.length() : text.getBytes(StandardCharsets.UTF_8).length;
        }

        @Override
        public Supplier<Accumulator> supplier() {
            return () -> new Accumulator();
        }

        @Override
        public BiConsumer<Accumulator, String> accumulator() {
            return Accumulator::add;
        }

        @Override
        public BinaryOperator<Accumulator> combiner() {
            return Accumulator::combine;
        }

        @Override
        public Function<Accumulator, List<String>> finisher() {
            return Accumulator::truncate;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }

        private class Accumulator {
            private final List<String> chunks = new ArrayList<String>();
            private int length = 0;
            private boolean truncated = false;

            private Accumulator() {
            }

            Accumulator combine(Accumulator other) {
                other.chunks.forEach(this::add);
                return this;
            }

            void add(String chunk) {
                if (this.truncated) {
                    return;
                }
                if (this.length + Joiner.this.getLength(chunk) > Joiner.this.maxLength) {
                    this.truncated = true;
                    return;
                }
                this.chunks.add(chunk);
                this.length += Joiner.this.getLength(chunk);
            }

            List<String> truncate() {
                if (this.truncated) {
                    if (this.length + Joiner.this.getLength(Joiner.this.truncationText) > Joiner.this.maxLength) {
                        this.chunks.remove(this.chunks.size() - 1);
                    }
                    this.chunks.add(Joiner.this.truncationText);
                }
                return this.chunks;
            }
        }
    }
}

